/*
 * Decompiled with CFR 0.152.
 */
package org.jglue.cdiunit.internal;

import java.lang.annotation.Annotation;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.api.literal.ApplicationScopedLiteral;
import org.apache.deltaspike.core.api.literal.SingletonLiteral;
import org.apache.deltaspike.core.util.metadata.builder.AnnotatedTypeBuilder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestScopeExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestScopeExtension.class);
    private final Class<?> testClass;
    private final Annotation annotationScope;

    public TestScopeExtension() {
        this(null);
    }

    public TestScopeExtension(Class<?> testClass) {
        this.testClass = testClass;
        this.annotationScope = testClass != null && testClass.getAnnotation(RunWith.class).value() == Parameterized.class ? new SingletonLiteral() : new ApplicationScopedLiteral();
        LOGGER.debug("A classe de teste {} ter\u00e1 o escopo {}", testClass, (Object)this.annotationScope);
    }

    <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> pat) {
        AnnotatedType annotatedType = pat.getAnnotatedType();
        if (annotatedType.getJavaClass().equals(this.testClass)) {
            AnnotatedTypeBuilder builder = new AnnotatedTypeBuilder().readFromType(annotatedType).addToClass(this.annotationScope);
            pat.setAnnotatedType(builder.create());
        }
    }
}

