/*
 * Decompiled with CFR 0.152.
 */
package br.jus.tst.tstunit.cdi;

import br.jus.tst.tstunit.AbstractExtensao;
import br.jus.tst.tstunit.Configuracao;
import br.jus.tst.tstunit.TestUnitException;
import br.jus.tst.tstunit.cdi.CdiException;
import br.jus.tst.tstunit.cdi.HabilitarCdiAndMockito;
import br.jus.tst.tstunit.time.MedidorTempoExecucao;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Optional;
import javax.naming.InitialContext;
import org.jboss.weld.bootstrap.api.Bootstrap;
import org.jboss.weld.bootstrap.api.CDI11Bootstrap;
import org.jboss.weld.bootstrap.spi.Deployment;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.jboss.weld.resources.spi.ResourceLoader;
import org.jglue.cdiunit.internal.WeldTestUrlDeployment;
import org.junit.Test;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiExtensao
extends AbstractExtensao<HabilitarCdiAndMockito> {
    private static final long serialVersionUID = 2619723714870085508L;
    private static final Logger LOGGER = LoggerFactory.getLogger(CdiExtensao.class);
    private transient Weld weld;
    private transient WeldContainer container;
    private transient Throwable startupException;

    public CdiExtensao(Class<?> classeTeste) {
        super(classeTeste);
    }

    public <T> Optional<T> getInstanciaPersonalizadaParaTestes() {
        try {
            this.weld = new CdiUnitWeld();
            try {
                this.container = (WeldContainer)MedidorTempoExecucao.getInstancia().medir(w -> this.weld.initialize(), "Inicializa\u00e7\u00e3o do WELD").apply(this.weld);
            }
            catch (ClassFormatError error) {
                throw error;
            }
            catch (Throwable exception) {
                if (this.startupException == null) {
                    this.startupException = exception;
                }
            }
        }
        catch (Throwable exception) {
            this.startupException = new Exception("Erro ao inicializar Weld", exception);
        }
        return this.logExceptionIfExists().createTest(this.classeTeste);
    }

    private CdiExtensao logExceptionIfExists() {
        if (this.startupException != null) {
            LOGGER.warn("Erro ao inicializar Weld. Pode ser que essa exce\u00e7\u00e3o seja esperada em seu teste, portanto a execu\u00e7\u00e3o n\u00e3o ser\u00e1 interrompida.", this.startupException);
        }
        return this;
    }

    private Optional<?> createTest(Class<?> testClass) {
        return Optional.of(this.container.instance().select(testClass, new Annotation[0]).get());
    }

    public void inicializar(Configuracao configuracao, RunNotifier notifier) {
        this.assertExtensaoHabilitada();
        LOGGER.info("CDI habilitado");
    }

    public Statement criarStatement(Statement defaultStatement, FrameworkMethod method) throws TestUnitException {
        this.assertExtensaoHabilitada();
        LOGGER.info("Ativando contexto CDI");
        return new CdiStatement(defaultStatement, method);
    }

    private final class CdiStatement
    extends Statement {
        private static final String BEAN_MANAGER_JNDI_NAME = "java:comp/BeanManager";
        private final transient Statement defaultStatement;
        private final transient FrameworkMethod method;

        CdiStatement(Statement defaultStatement, FrameworkMethod method) {
            this.defaultStatement = defaultStatement;
            this.method = method;
        }

        public void evaluate() throws Throwable {
            if (CdiExtensao.this.startupException != null) {
                if (((Test)this.method.getAnnotation(Test.class)).expected() == CdiExtensao.this.startupException.getClass()) {
                    return;
                }
                throw CdiExtensao.this.startupException;
            }
            System.setProperty("java.naming.factory.initial", this.carregarNomeClasseCdiUnitContextFactory());
            InitialContext initialContext = new InitialContext();
            initialContext.bind(BEAN_MANAGER_JNDI_NAME, (Object)CdiExtensao.this.container.getBeanManager());
            try {
                this.defaultStatement.evaluate();
            }
            finally {
                initialContext.close();
                CdiExtensao.this.weld.shutdown();
            }
        }

        private String carregarNomeClasseCdiUnitContextFactory() {
            String cdiUnitContextFactory = "org.jglue.cdiunit.internal.naming.CdiUnitContextFactory";
            try {
                Class.forName(cdiUnitContextFactory);
            }
            catch (ClassNotFoundException exception) {
                LOGGER.trace(exception.getLocalizedMessage(), (Throwable)exception);
                cdiUnitContextFactory = "org.jglue.cdiunit.internal.CdiUnitContextFactory";
            }
            return cdiUnitContextFactory;
        }
    }

    private final class CdiUnitWeld
    extends Weld {
        private CdiUnitWeld() {
        }

        protected Deployment createDeployment(ResourceLoader resourceLoader, Bootstrap bootstrap) {
            try {
                return new WeldTestUrlDeployment(resourceLoader, bootstrap, CdiExtensao.this.classeTeste);
            }
            catch (IOException exception) {
                CdiExtensao.this.startupException = exception;
                throw new CdiException("Erro ao criar Deployment", exception);
            }
        }

        protected Deployment createDeployment(ResourceLoader resourceLoader, CDI11Bootstrap bootstrap) {
            try {
                return new WeldTestUrlDeployment(resourceLoader, (Bootstrap)bootstrap, CdiExtensao.this.classeTeste);
            }
            catch (IOException exception) {
                CdiExtensao.this.startupException = exception;
                throw new CdiException("Erro ao criar Deployment", exception);
            }
        }
    }
}

