/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.apigov.javaclient;

import br.gov.serpro.apigov.javaclient.exceptions.NoMethodException;
import br.gov.serpro.apigov.javaclient.internal.ClientFactory;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

public class ApigovSDK {
    private Client client;
    private String token;
    private String uri;
    private String path;
    private Map<String, String> queryParams = new LinkedHashMap<String, String>();
    private METHOD method;
    private Form formData;

    public ApigovSDK(String token, String uri) {
        this.token = token;
        this.uri = uri;
        this.client = ClientFactory.createClient();
    }

    public ApigovSDK queryParam(String key, String value) {
        this.queryParams.put(key, value);
        return this;
    }

    public ApigovSDK get(String path) {
        this.method = METHOD.GET;
        this.path = path;
        return this;
    }

    public ApigovSDK post(String path, Form formData) {
        this.method = METHOD.POST;
        this.formData = formData;
        return this;
    }

    public Response request() {
        if (this.method == null) {
            throw new NoMethodException();
        }
        Invocation.Builder builder = this.createBuilder(this.path);
        Response response = null;
        if (METHOD.GET.equals((Object)this.method)) {
            response = (Response)builder.get(Response.class);
        } else if (METHOD.POST.equals((Object)this.method)) {
            response = (Response)builder.post(Entity.entity((Object)this.formData, (MediaType)MediaType.APPLICATION_FORM_URLENCODED_TYPE), Response.class);
        }
        this.handleStatus(response);
        this.clearData();
        return response;
    }

    private void clearData() {
        this.path = null;
        this.queryParams.clear();
        this.method = null;
        this.formData = null;
    }

    private Invocation.Builder createBuilder(String path) {
        WebTarget target = this.client.target(this.uri);
        if (path != null) {
            target = target.path(path);
        }
        if (this.queryParams != null) {
            for (Map.Entry<String, String> entry : this.queryParams.entrySet()) {
                target = target.queryParam(entry.getKey(), new Object[]{entry.getValue()});
            }
            this.queryParams.clear();
        }
        Invocation.Builder builder = target.request(new String[]{"application/json"});
        if (this.token != null) {
            builder = builder.header("Authorization", (Object)("Bearer " + this.token));
        }
        return builder;
    }

    private void handleStatus(Response response) {
        if (response.getStatus() < 200 || response.getStatus() >= 300) {
            System.err.println((String)response.readEntity(String.class));
            throw new RuntimeException((String)response.readEntity(String.class));
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("{\n");
        sb.append("  'token':'" + this.token + "',\n");
        sb.append("  'uri':'" + this.uri + "',\n");
        sb.append("  'path':'" + this.path + "',\n");
        sb.append("  'method':'" + (Object)((Object)this.method) + "',\n");
        sb.append("  'queryParams':'" + this.queryParams + "',\n");
        sb.append("  'formData':'" + this.formData + "'\n");
        sb.append("}");
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum METHOD {
        GET,
        POST;

    }
}

