/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.util.Strings;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class CacheFilter
implements Filter {
    private String value;

    public void init(FilterConfig config) throws ServletException {
        this.value = config.getInitParameter("value");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (response instanceof HttpServletResponse) {
            this.setCacheControl((HttpServletResponse)response);
        }
        chain.doFilter(request, response);
    }

    protected void setCacheControl(HttpServletResponse response) {
        if (Strings.isEmpty((String)response.getHeader("Cache-Control"))) {
            response.setHeader("Cache-Control", this.value);
        }
    }

    public void destroy() {
    }
}

