/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.security.Authorizer;
import br.gov.frameworkdemoiselle.security.RequiredPermission;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import javax.servlet.http.HttpServletRequest;

@Priority(value=2147483547)
public class ServletAuthorizer
implements Authorizer {
    private static final long serialVersionUID = 1L;
    private transient ResourceBundle bundle;

    public boolean hasRole(String role) throws Exception {
        return this.getRequest().isUserInRole(role);
    }

    public boolean hasPermission(String resource, String operation) throws Exception {
        throw new DemoiselleException(this.getBundle().getString("has-permission-not-supported", new Object[]{RequiredPermission.class.getSimpleName()}));
    }

    private HttpServletRequest getRequest() {
        return (HttpServletRequest)Beans.getReference(HttpServletRequest.class);
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-servlet-bundle")});
        }
        return this.bundle;
    }
}

