/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.security.AuthenticationException;
import br.gov.frameworkdemoiselle.security.Authenticator;
import br.gov.frameworkdemoiselle.security.Credentials;
import br.gov.frameworkdemoiselle.security.InvalidCredentialsException;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.security.Principal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

@Priority(value=2147483547)
public class ServletAuthenticator
implements Authenticator {
    private static final long serialVersionUID = 1L;
    private static ResourceBundle bundle;

    public void authenticate() throws Exception {
        try {
            this.getRequest().login(this.getCredentials().getUsername(), this.getCredentials().getPassword());
        }
        catch (ServletException cause) {
            if (cause.getMessage().toLowerCase().contains("invalid") || cause.getMessage().toLowerCase().contains("incorrect") || cause.getMessage().toLowerCase().contains("failed")) {
                throw new InvalidCredentialsException();
            }
            throw new AuthenticationException(ServletAuthenticator.getBundle().getString("authentication-failed"), (Throwable)cause);
        }
    }

    public void unauthenticate() throws Exception {
        this.getCredentials().clear();
        try {
            this.getRequest().logout();
        }
        catch (ServletException servletException) {
            // empty catch block
        }
        this.getRequest().getSession().invalidate();
    }

    public Principal getUser() {
        return this.getRequest().getUserPrincipal();
    }

    protected Credentials getCredentials() {
        return (Credentials)Beans.getReference(Credentials.class);
    }

    private HttpServletRequest getRequest() {
        return (HttpServletRequest)Beans.getReference(HttpServletRequest.class);
    }

    private static ResourceBundle getBundle() {
        if (bundle == null) {
            bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-servlet-bundle")});
        }
        return bundle;
    }
}

