/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.StaticScoped;
import br.gov.frameworkdemoiselle.internal.implementation.BasicAuthenticationFilter;
import br.gov.frameworkdemoiselle.internal.implementation.HttpServletRequestProducerFilter;
import br.gov.frameworkdemoiselle.internal.implementation.HttpServletResponseProducerFilter;
import br.gov.frameworkdemoiselle.util.ServletFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

@StaticScoped
public class InternalProcessorFilterImpl
implements ServletFilter.InternalProcessorFilter {
    private List<Filter> filters = new ArrayList<Filter>();

    public InternalProcessorFilterImpl() {
        this.filters.add(new HttpServletRequestProducerFilter());
        this.filters.add(new HttpServletResponseProducerFilter());
        this.filters.add(new BasicAuthenticationFilter());
    }

    public void init(FilterConfig config) throws ServletException {
        for (Filter filter : this.filters) {
            filter.init(config);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        FilterChain emptyChain = this.createEmptyChain();
        for (Filter filter : this.filters) {
            filter.doFilter(request, response, emptyChain);
        }
    }

    public void destroy() {
        for (Filter filter : this.filters) {
            filter.destroy();
        }
    }

    private FilterChain createEmptyChain() {
        return new FilterChain(){

            public void doFilter(ServletRequest request, ServletResponse response) throws IOException, ServletException {
            }
        };
    }
}

