/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.security.AuthenticationException;
import br.gov.frameworkdemoiselle.security.Credentials;
import br.gov.frameworkdemoiselle.security.SecurityContext;
import br.gov.frameworkdemoiselle.util.Beans;
import java.io.IOException;
import java.util.Arrays;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthenticationFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String[] basicCredentials = this.getCredentials((HttpServletRequest)request);
        if (basicCredentials != null) {
            Credentials credentials = (Credentials)Beans.getReference(Credentials.class);
            credentials.setUsername(basicCredentials[0]);
            credentials.setPassword(basicCredentials[1]);
            try {
                ((SecurityContext)Beans.getReference(SecurityContext.class)).login();
            }
            catch (AuthenticationException cause) {
                // empty catch block
            }
        }
        chain.doFilter(request, response);
    }

    private String getAuthHeader(HttpServletRequest request) {
        String result = request.getHeader("Authorization");
        result = result == null ? request.getHeader("authorization") : result;
        return result;
    }

    private String[] getCredentials(HttpServletRequest request) {
        String[] result = null;
        String header = this.getAuthHeader(request);
        if (header != null) {
            byte[] decoded = Base64.decodeBase64((String)header.substring(6));
            result = new String(decoded).split(":");
        }
        if (result != null && Arrays.asList(result).size() != 2) {
            result = null;
        }
        return result;
    }

    public void destroy() {
    }
}

