/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.security.TokenManager;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
@Priority(value=2147483547)
public class DefaultTokenManager
implements TokenManager {
    private TokenStore store = new TokenStore();

    @Override
    public String persist(Principal user) throws Exception {
        return this.store.put(user);
    }

    @Override
    public Principal load(String token) throws Exception {
        return this.store.get(token);
    }

    public static class TokenStore
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, Principal> map = Collections.synchronizedMap(new HashMap());

        public String put(Principal user) {
            String token = UUID.randomUUID().toString();
            if (this.map.containsValue(user)) {
                this.map.remove(token);
            }
            this.map.put(token, user);
            return token;
        }

        public Principal get(String token) {
            return this.map.get(token);
        }
    }
}

