/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.EOFException;
import java.lang.annotation.Annotation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class EOFExceptionMapper
implements ExceptionMapper<EOFException> {
    private transient ResourceBundle bundle;
    private transient Logger logger;

    public Response toResponse(EOFException exception) {
        int status = 400;
        String message = this.getBundle().getString("mapping-violations", new Object[]{status});
        this.getLogger().log(Level.FINE, message, exception);
        return Response.status((int)status).build();
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-rest-bundle")});
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = (Logger)Beans.getReference(Logger.class, (Annotation[])new Annotation[]{new NameQualifier("br.gov.frameworkdemoiselle.exception")});
        }
        return this.logger;
    }
}

