/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.internal.configuration.RESTSecurityConfig;
import br.gov.frameworkdemoiselle.security.AbstractHTTPAuthorizationFilter;
import br.gov.frameworkdemoiselle.security.Token;
import br.gov.frameworkdemoiselle.util.Beans;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TokenAuthFilter
extends AbstractHTTPAuthorizationFilter {
    @Override
    protected String getType() {
        return "Token";
    }

    @Override
    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String authData = this.getAuthData(request);
        super.doFilter(request, response, chain);
        String value = ((Token)Beans.getReference(Token.class)).getValue();
        if (value != null && !value.equals(authData)) {
            response.setHeader("Set-Token", value);
        }
    }

    @Override
    protected void performLogin(HttpServletRequest request, HttpServletResponse response) {
        Token token = (Token)Beans.getReference(Token.class);
        String authData = this.getAuthData(request);
        token.setValue(authData);
        super.performLogin(request, response);
    }

    @Override
    protected boolean isActive() {
        return ((RESTSecurityConfig)Beans.getReference(RESTSecurityConfig.class)).isTokenFilterActive();
    }
}

