/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.security.AbstractHTTPAuthorizationFilter;
import br.gov.frameworkdemoiselle.security.Credentials;
import br.gov.frameworkdemoiselle.security.InvalidCredentialsException;
import br.gov.frameworkdemoiselle.security.RESTSecurityConfig;
import br.gov.frameworkdemoiselle.util.Beans;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthFilter
extends AbstractHTTPAuthorizationFilter {
    @Override
    protected String getType() {
        return "Basic";
    }

    @Override
    protected void performLogin(HttpServletRequest request, HttpServletResponse response) {
        String[] decoded = this.decodeCredentials(request);
        Credentials credentials = (Credentials)Beans.getReference(Credentials.class);
        credentials.setUsername(decoded[0]);
        credentials.setPassword(decoded[1]);
        super.performLogin(request, response);
    }

    private String[] decodeCredentials(HttpServletRequest request) throws InvalidCredentialsException {
        String[] result = null;
        String authData = this.getAuthData(request);
        byte[] decoded = Base64.decodeBase64((String)authData);
        result = new String(decoded).split(":");
        if (result == null || result.length != 2) {
            throw new InvalidCredentialsException("formato inv\u00e1lido do cabe\u00e7alho");
        }
        return result;
    }

    @Override
    protected boolean isActive() {
        return ((RESTSecurityConfig)Beans.getReference(RESTSecurityConfig.class)).isBasicFilterActive();
    }
}

