/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.security.AuthenticationException;
import br.gov.frameworkdemoiselle.security.InvalidCredentialsException;
import br.gov.frameworkdemoiselle.security.SecurityContext;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Strings;
import java.io.IOException;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractHTTPAuthorizationFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest && response instanceof HttpServletResponse) {
            this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
        } else {
            chain.doFilter(request, response);
        }
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isActive() && this.isSupported(request)) {
            try {
                this.performLogin(request, response);
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                this.performLogout(request, response);
            }
            catch (InvalidCredentialsException cause) {
                this.setUnauthorizedStatus(response, (AuthenticationException)cause);
            }
        } else {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    protected String getAuthHeader(HttpServletRequest request) {
        String value = null;
        Enumeration names = request.getHeaderNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            if (!"authorization".equalsIgnoreCase(name)) continue;
            value = request.getHeader(name);
            break;
        }
        return value;
    }

    protected String getAuthData(HttpServletRequest request) throws InvalidCredentialsException {
        String regexp;
        Pattern pattern;
        Matcher matcher;
        String authData = null;
        String authHeader = this.getAuthHeader(request);
        String type = this.getType();
        if (!Strings.isEmpty((String)type) && !Strings.isEmpty((String)authHeader) && (matcher = (pattern = Pattern.compile(regexp = "^" + type + "[ \\n]+(.+)$", 2)).matcher(authHeader)).matches()) {
            authData = matcher.group(1);
        }
        return authData;
    }

    protected boolean isSupported(HttpServletRequest request) {
        String data = this.getAuthData(request);
        return !Strings.isEmpty((String)data);
    }

    protected abstract boolean isActive();

    protected abstract String getType();

    protected void performLogin(HttpServletRequest request, HttpServletResponse response) {
        ((SecurityContext)Beans.getReference(SecurityContext.class)).login();
    }

    protected void performLogout(HttpServletRequest request, HttpServletResponse response) {
        if (((SecurityContext)Beans.getReference(SecurityContext.class)).isLoggedIn()) {
            ((SecurityContext)Beans.getReference(SecurityContext.class)).logout();
        }
    }

    private void setUnauthorizedStatus(HttpServletResponse response, AuthenticationException cause) throws IOException {
        response.setStatus(401);
        response.setContentType("text/plain; charset=UTF-8");
        response.getWriter().write(cause.getMessage());
    }
}

