/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.HttpViolationException;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Logger;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class HttpViolationExceptionMapper
implements ExceptionMapper<HttpViolationException> {
    private transient ResourceBundle bundle;
    private transient Logger logger;

    public Response toResponse(HttpViolationException exception) {
        Set<HttpViolationException.Violation> violations = exception.getViolations();
        int status = exception.getStatusCode();
        if (violations.isEmpty()) {
            violations = null;
        } else {
            this.getLogger().fine(this.getBundle().getString("mapping-violations", new Object[]{status, violations.toString()}));
        }
        return Response.status((int)status).entity(violations).build();
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-rest-bundle")});
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = (Logger)Beans.getReference(Logger.class, (Annotation[])new Annotation[]{new NameQualifier(HttpViolationExceptionMapper.class.getName())});
        }
        return this.logger;
    }
}

