/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.UnprocessableEntityException;
import br.gov.frameworkdemoiselle.internal.implementation.HttpViolationExceptionMapper;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

@Provider
public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    private transient ResourceBundle bundle;
    private transient Logger logger;

    public Response toResponse(ConstraintViolationException exception) {
        UnprocessableEntityException failed = new UnprocessableEntityException();
        int status = new UnprocessableEntityException().getStatusCode();
        for (ConstraintViolation violation : exception.getConstraintViolations()) {
            failed.addViolation(violation.getPropertyPath().toString(), violation.getMessage());
        }
        this.getLogger().fine(this.getBundle().getString("mapping-violations", new Object[]{status, failed.getViolations().toString()}));
        return Response.status((int)status).entity(failed.getViolations()).build();
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-rest-bundle")});
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = (Logger)Beans.getReference(Logger.class, (Annotation[])new Annotation[]{new NameQualifier(HttpViolationExceptionMapper.class.getName())});
        }
        return this.logger;
    }
}

