/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle;

import java.util.HashSet;
import java.util.Set;

public class HttpViolationException
extends Exception {
    private static final long serialVersionUID = 1L;
    private Set<Violation> violations = new HashSet<Violation>();
    private int statusCode;

    public HttpViolationException(int statusCode) {
        this.statusCode = statusCode;
    }

    public HttpViolationException addViolation(String message) {
        return this.addViolation(null, message);
    }

    public HttpViolationException addViolation(String property, String message) {
        this.violations.add(new Violation(property, message));
        return this;
    }

    public Set<Violation> getViolations() {
        return this.violations;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public static class Violation {
        public String property;
        public String message;

        public Violation() {
        }

        public Violation(String property, String message) {
            this.property = property;
            this.message = message;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
            result = 31 * result + (this.property == null ? 0 : this.property.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Violation other = (Violation)obj;
            if (this.message == null ? other.message != null : !this.message.equals(other.message)) {
                return false;
            }
            return !(this.property == null ? other.property != null : !this.property.equals(other.property));
        }

        public String toString() {
            return this.property + " " + this.message;
        }
    }
}

