/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.security.AbstractHTTPAuthorizationFilter;
import br.gov.frameworkdemoiselle.security.Credentials;
import br.gov.frameworkdemoiselle.security.InvalidCredentialsException;
import br.gov.frameworkdemoiselle.security.RESTSecurityConfig;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Strings;
import org.apache.commons.codec.binary.Base64;

public class BasicAuthFilter
extends AbstractHTTPAuthorizationFilter {
    private String credentials;

    @Override
    protected boolean isSupported(String authHeader) {
        this.credentials = BasicAuthFilter.extractCredentials("Basic", authHeader);
        return !Strings.isEmpty((String)this.credentials);
    }

    @Override
    protected boolean isActive(RESTSecurityConfig config) {
        return config.isBasicFilterActive();
    }

    @Override
    protected void prepareForLogin() {
        String[] basicCredentials = BasicAuthFilter.getCredentials(this.credentials);
        Credentials credentials = (Credentials)Beans.getReference(Credentials.class);
        credentials.setUsername(basicCredentials[0]);
        credentials.setPassword(basicCredentials[1]);
    }

    @Override
    protected void prepareForLogout() {
    }

    private static String[] getCredentials(String header) throws InvalidCredentialsException {
        String[] result = null;
        byte[] decoded = Base64.decodeBase64((String)header);
        result = new String(decoded).split(":");
        if (result == null || result.length != 2) {
            throw new InvalidCredentialsException("Formato inv\u00e1lido do cabe\u00e7alho");
        }
        return result;
    }
}

