/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.security;

import br.gov.frameworkdemoiselle.security.AuthenticationException;
import br.gov.frameworkdemoiselle.security.InvalidCredentialsException;
import br.gov.frameworkdemoiselle.security.RESTSecurityConfig;
import br.gov.frameworkdemoiselle.security.SecurityContext;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Strings;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractHTTPAuthorizationFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RESTSecurityConfig config = (RESTSecurityConfig)Beans.getReference(RESTSecurityConfig.class);
        if (request instanceof HttpServletRequest && this.isActive(config) && this.isSupported(this.getAuthHeader((HttpServletRequest)request))) {
            try {
                this.performLogin((HttpServletRequest)request);
                chain.doFilter((ServletRequest)((HttpServletRequest)request), (ServletResponse)((HttpServletResponse)response));
                this.performLogout();
            }
            catch (InvalidCredentialsException cause) {
                this.setUnauthorizedStatus((HttpServletResponse)response, (AuthenticationException)cause);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    private String getAuthHeader(HttpServletRequest request) {
        String result = request.getHeader("Authorization");
        return result == null ? request.getHeader("authorization") : result;
    }

    protected abstract boolean isSupported(String var1);

    protected abstract boolean isActive(RESTSecurityConfig var1);

    protected abstract void prepareForLogin();

    private void performLogin(HttpServletRequest request) {
        this.prepareForLogin();
        ((SecurityContext)Beans.getReference(SecurityContext.class)).login();
    }

    protected abstract void prepareForLogout();

    private void performLogout() {
        if (((SecurityContext)Beans.getReference(SecurityContext.class)).isLoggedIn()) {
            this.prepareForLogout();
            ((SecurityContext)Beans.getReference(SecurityContext.class)).logout();
        }
    }

    private void setUnauthorizedStatus(HttpServletResponse response, AuthenticationException cause) throws IOException {
        response.setStatus(401);
        response.setContentType("text/plain");
        response.getWriter().write(cause.getMessage());
    }

    protected static String extractCredentials(String type, String authHeader) throws InvalidCredentialsException {
        String regexp;
        Pattern pattern;
        Matcher matcher;
        String result = null;
        if (!Strings.isEmpty((String)type) && !Strings.isEmpty((String)authHeader) && (matcher = (pattern = Pattern.compile(regexp = "^" + type + "[ \\n]+(.+)$")).matcher(authHeader)).matches()) {
            result = matcher.group(1);
        }
        return result;
    }
}

