/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.transaction;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.util.Beans;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

@Priority(value=0x7FFFFF37)
public class JTATransaction
implements Transaction {
    private static final long serialVersionUID = 1L;
    private UserTransaction delegate;

    private UserTransaction getDelegate() {
        if (this.delegate == null) {
            this.delegate = (UserTransaction)Beans.getReference(UserTransaction.class);
        }
        return this.delegate;
    }

    public boolean isActive() {
        try {
            return this.getDelegate().getStatus() != 6;
        }
        catch (SystemException cause) {
            throw new DemoiselleException((Throwable)cause);
        }
    }

    public boolean isMarkedRollback() {
        try {
            return this.getDelegate().getStatus() == 1 || this.getDelegate().getStatus() == 4;
        }
        catch (SystemException cause) {
            throw new DemoiselleException((Throwable)cause);
        }
    }

    public void begin() {
        try {
            this.getDelegate().begin();
        }
        catch (Exception cause) {
            throw new DemoiselleException((Throwable)cause);
        }
    }

    public void commit() {
        try {
            this.getDelegate().commit();
        }
        catch (Exception cause) {
            throw new DemoiselleException((Throwable)cause);
        }
    }

    public void rollback() {
        try {
            this.getDelegate().rollback();
        }
        catch (SystemException cause) {
            throw new DemoiselleException((Throwable)cause);
        }
    }

    public void setRollbackOnly() {
        try {
            this.getDelegate().setRollbackOnly();
        }
        catch (SystemException cause) {
            throw new DemoiselleException((Throwable)cause);
        }
    }
}

