/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.procuder;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.faces.context.FacesContext;

public class FacesContextProducer {
    @Produces
    @Dependent
    public FacesContext create(InjectionPoint ip, @Name(value="demoiselle-jsf-bundle") ResourceBundle bundle, Logger logger) {
        FacesContext context;
        if (ip != null && !ip.isTransient()) {
            Member member = ip.getMember();
            if (member != null) {
                Class<?> declaringClass = member.getDeclaringClass();
                if (Serializable.class.isAssignableFrom(declaringClass)) {
                    throw new DemoiselleException(bundle.getString("faces-context-not-passivable", new Object[]{member.getName(), declaringClass.getCanonicalName()}), (Throwable)new NotSerializableException(FacesContext.class.getCanonicalName()));
                }
            } else if (Beans.ProgramaticInjectionPoint.class.isInstance(ip)) {
                logger.fine(bundle.getString("faces-context-passivation-warning"));
            }
        }
        if ((context = FacesContext.getCurrentInstance()) == null) {
            throw new ContextNotActiveException(bundle.getString("faces-context-not-available"));
        }
        return context;
    }
}

