/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.context.ViewContext;
import br.gov.frameworkdemoiselle.internal.context.AbstractCustomContext;
import br.gov.frameworkdemoiselle.internal.context.BeanStore;
import br.gov.frameworkdemoiselle.internal.context.FacesViewBeanStore;
import br.gov.frameworkdemoiselle.lifecycle.ViewScoped;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Faces;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.inject.Alternative;
import javax.faces.context.FacesContext;

@Priority(value=2147483547)
@Alternative
public class FacesViewContextImpl
extends AbstractCustomContext
implements ViewContext {
    private static final AtomicLong atomicLong = new AtomicLong();
    private static final String FACES_KEY = FacesViewContextImpl.class.getCanonicalName();
    private FacesViewBeanStore viewStoreInSession;

    public FacesViewContextImpl() {
        super(ViewScoped.class);
    }

    protected boolean isStoreInitialized() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context != null && context.getViewRoot().getViewMap(false) != null;
    }

    private FacesViewBeanStore getViewStore() {
        if (this.viewStoreInSession == null) {
            this.viewStoreInSession = (FacesViewBeanStore)Beans.getReference(FacesViewBeanStore.class);
        }
        return this.viewStoreInSession;
    }

    protected BeanStore getStore() {
        Long viewId = (Long)Faces.getViewMap().get(FACES_KEY);
        if (viewId == null) {
            viewId = atomicLong.incrementAndGet();
            Faces.getViewMap().put(FACES_KEY, viewId);
        }
        return this.getViewStore().getStoreForView(viewId);
    }

    public void clearView() {
        Long viewId = (Long)Faces.getViewMap().get(FACES_KEY);
        if (viewId == null) {
            return;
        }
        this.getViewStore().destroyStore(viewId);
    }
}

