/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.internal.bootstrap.CustomContextBootstrap;
import br.gov.frameworkdemoiselle.internal.context.AbstractCustomContext;
import br.gov.frameworkdemoiselle.internal.context.BeanStore;
import br.gov.frameworkdemoiselle.internal.context.ContextualStore;
import br.gov.frameworkdemoiselle.util.Faces;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.inject.Inject;

@SessionScoped
public class FacesViewBeanStore
implements Serializable {
    private static final long serialVersionUID = -8265458933971929432L;
    public static final String PARAM_NAME_MAX_ACTIVE_VIEW_SCOPES = "br.gov.frameworkdemoiselle.MAX_ACTIVE_VIEW_SCOPES";
    public static final String PARAM_NAME_MOJARRA_NUMBER_OF_VIEWS = "com.sun.faces.numberOfLogicalViews";
    public static final String PARAM_NAME_MYFACES_NUMBER_OF_VIEWS = "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION";
    public static final int DEFAULT_MAX_ACTIVE_VIEW_SCOPES = 20;
    private static final String[] PARAM_NAMES_MAX_ACTIVE_VIEW_SCOPES = new String[]{"br.gov.frameworkdemoiselle.MAX_ACTIVE_VIEW_SCOPES", "com.sun.faces.numberOfLogicalViews", "org.apache.myfaces.NUMBER_OF_VIEWS_IN_SESSION"};
    private static volatile Integer maxActiveViewScopes;
    private Map<Long, BeanStore> viewStore;
    @Inject
    private CustomContextBootstrap bootstrap;

    @PostConstruct
    protected void postConstruct() {
        this.viewStore = Collections.synchronizedMap(new LRUViewStoreMap());
    }

    public BeanStore getStoreForView(Long viewId) {
        BeanStore store = this.viewStore.get(viewId);
        if (store == null) {
            store = AbstractCustomContext.createStore();
            this.viewStore.put(viewId, store);
        }
        return store;
    }

    @PreDestroy
    public void destroyStores() {
        Iterator<Map.Entry<Long, BeanStore>> it = this.viewStore.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, BeanStore> currentEntry = it.next();
            BeanStore store = currentEntry.getValue();
            this.destroyStore(store);
            it.remove();
        }
    }

    public void destroyStore(Long viewId) {
        BeanStore store = this.viewStore.remove(viewId);
        if (store != null) {
            this.destroyStore(store);
        }
    }

    private void destroyStore(BeanStore store) {
        ContextualStore contextualStore = this.bootstrap.getContextualStore();
        for (String id : store) {
            Contextual contextual = contextualStore.getContextual(id);
            Object instance = store.getInstance(id);
            CreationalContext creationalContext = store.getCreationalContext(id);
            if (contextual == null || instance == null) continue;
            contextual.destroy(instance, creationalContext);
        }
        store.clear();
    }

    private static int getMaxActiveViewScopes() {
        if (maxActiveViewScopes != null) {
            return maxActiveViewScopes;
        }
        for (String name : PARAM_NAMES_MAX_ACTIVE_VIEW_SCOPES) {
            String value = Faces.getInitParameter(name);
            if (value == null) continue;
            try {
                maxActiveViewScopes = Integer.valueOf(value);
                return maxActiveViewScopes;
            }
            catch (NumberFormatException e) {
                String message = FacesViewBeanStore.getMessageBundle().getString("max-active-view-scopes-param-invalid");
                throw new IllegalArgumentException(MessageFormat.format(message, name, value), e);
            }
        }
        maxActiveViewScopes = 20;
        return maxActiveViewScopes;
    }

    private static ResourceBundle getMessageBundle() {
        return br.gov.frameworkdemoiselle.util.ResourceBundle.getBundle((String)"demoiselle-jsf-bundle");
    }

    private final class LRUViewStoreMap
    extends LinkedHashMap<Long, BeanStore> {
        private static final long serialVersionUID = -2520661683192850878L;

        private LRUViewStoreMap() {
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, BeanStore> eldest) {
            if (this.size() > FacesViewBeanStore.getMaxActiveViewScopes()) {
                FacesViewBeanStore.this.destroyStore(eldest.getValue());
                return true;
            }
            return false;
        }
    }
}

