/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.context;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.annotation.ViewScoped;
import br.gov.frameworkdemoiselle.context.ViewContext;
import br.gov.frameworkdemoiselle.internal.context.AbstractCustomContext;
import br.gov.frameworkdemoiselle.internal.context.BeanStore;
import br.gov.frameworkdemoiselle.internal.context.FacesViewBeanStore;
import br.gov.frameworkdemoiselle.lifecycle.BeforeSessionDestroyed;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Faces;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;

@Priority(value=2147483547)
@Alternative
public class FacesViewContextImpl
extends AbstractCustomContext
implements ViewContext {
    private final AtomicLong atomicLong = new AtomicLong();
    private ConcurrentHashMap<String, FacesViewBeanStore> sessionBeanStore = new ConcurrentHashMap();
    private static final String FACES_KEY = FacesViewContextImpl.class.getCanonicalName();

    public FacesViewContextImpl() {
        super(ViewScoped.class);
    }

    protected boolean isStoreInitialized() {
        return FacesContext.getCurrentInstance() != null && this.getSessionId() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BeanStore getStore() {
        FacesViewBeanStore currentStore;
        String sessionId = this.getSessionId();
        if (sessionId == null) {
            return null;
        }
        Long viewId = (Long)Faces.getViewMap().get(FACES_KEY);
        if (viewId == null) {
            FacesViewContextImpl facesViewContextImpl = this;
            synchronized (facesViewContextImpl) {
                viewId = (Long)Faces.getViewMap().get(FACES_KEY);
                if (viewId == null) {
                    viewId = this.atomicLong.incrementAndGet();
                    Faces.getViewMap().put(FACES_KEY, viewId);
                }
            }
        }
        if ((currentStore = this.sessionBeanStore.get(sessionId)) == null) {
            FacesViewContextImpl facesViewContextImpl = this;
            synchronized (facesViewContextImpl) {
                currentStore = this.sessionBeanStore.get(sessionId);
                if (currentStore == null) {
                    currentStore = new FacesViewBeanStore();
                    this.sessionBeanStore.put(sessionId, currentStore);
                }
            }
        }
        return currentStore.getStore(viewId, this);
    }

    private void clearInvalidatedSession(String sessionId) {
        FacesViewBeanStore store;
        if (sessionId != null && (store = this.sessionBeanStore.get(sessionId)) != null) {
            store.clear(this);
            this.sessionBeanStore.remove(sessionId);
        }
    }

    private String getSessionId() {
        HttpSession session = (HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(true);
        return session != null ? session.getId() : null;
    }

    @ApplicationScoped
    protected static class FacesViewSessionListener {
        protected FacesViewSessionListener() {
        }

        protected void clearInvalidatedSession(@Observes BeforeSessionDestroyed event) {
            String sessionId = event.getSessionId();
            try {
                Context context = Beans.getBeanManager().getContext(ViewScoped.class);
                if (FacesViewContextImpl.class.isInstance(context)) {
                    ((FacesViewContextImpl)context).clearInvalidatedSession(sessionId);
                }
            }
            catch (ContextNotActiveException contextNotActiveException) {
                // empty catch block
            }
        }
    }
}

