/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.configuration.JsfSecurityConfig;
import br.gov.frameworkdemoiselle.internal.implementation.AbstractExceptionHandler;
import br.gov.frameworkdemoiselle.internal.implementation.SecurityObserver;
import br.gov.frameworkdemoiselle.security.InvalidCredentialsException;
import br.gov.frameworkdemoiselle.security.NotLoggedInException;
import br.gov.frameworkdemoiselle.util.Beans;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;

public class AuthenticationExceptionHandler
extends AbstractExceptionHandler {
    private transient JsfSecurityConfig config;

    public AuthenticationExceptionHandler(ExceptionHandler wrapped) {
        super(wrapped);
    }

    @Override
    protected boolean handleException(Throwable cause, FacesContext facesContext) {
        boolean handled = false;
        if (cause instanceof NotLoggedInException || cause instanceof InvalidCredentialsException) {
            handled = true;
            if (this.getConfig().isRedirectEnabled()) {
                ((SecurityObserver)Beans.getReference(SecurityObserver.class)).redirectToLoginPage();
            } else {
                HttpServletResponse response = (HttpServletResponse)facesContext.getExternalContext().getResponse();
                response.setStatus(403);
            }
        }
        return handled;
    }

    public JsfSecurityConfig getConfig() {
        if (this.config == null) {
            this.config = (JsfSecurityConfig)Beans.getReference(JsfSecurityConfig.class);
        }
        return this.config;
    }
}

