/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.configuration.ConfigurationException;
import br.gov.frameworkdemoiselle.internal.configuration.JsfSecurityConfig;
import br.gov.frameworkdemoiselle.security.AfterLoginSuccessful;
import br.gov.frameworkdemoiselle.security.AfterLogoutSuccessful;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.PageNotFoundException;
import br.gov.frameworkdemoiselle.util.Redirector;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

@SessionScoped
public class SecurityObserver
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient JsfSecurityConfig config;
    private transient Map<String, Object> savedParams;
    private String savedViewId;
    @Inject
    private Logger logger;
    @Inject
    @Name(value="demoiselle-jsf-bundle")
    private ResourceBundle bundle;

    public SecurityObserver() {
        this.clear();
    }

    private Map<String, Object> getSavedParams() {
        if (this.savedParams == null) {
            this.savedParams = new HashMap<String, Object>();
        }
        return this.savedParams;
    }

    public JsfSecurityConfig getConfig() {
        if (this.config == null) {
            this.config = (JsfSecurityConfig)Beans.getReference(JsfSecurityConfig.class);
        }
        return this.config;
    }

    private void saveCurrentState() {
        this.clear();
        FacesContext facesContext = (FacesContext)Beans.getReference(FacesContext.class);
        if (!this.getConfig().getLoginPage().equals(facesContext.getViewRoot().getViewId())) {
            this.getSavedParams().putAll(facesContext.getExternalContext().getRequestParameterMap());
            this.savedViewId = facesContext.getViewRoot().getViewId();
        }
    }

    public void redirectToLoginPage() {
        this.saveCurrentState();
        try {
            Redirector.redirect(this.getConfig().getLoginPage());
        }
        catch (PageNotFoundException cause) {
            throw new ConfigurationException(this.bundle.getString("login-page-not-found", new Object[]{cause.getViewId()}), (Throwable)((Object)cause));
        }
    }

    public void onLoginSuccessful(@Observes AfterLoginSuccessful event) {
        boolean redirectedFromConfig = false;
        try {
            if (this.savedViewId != null) {
                Redirector.redirect(this.savedViewId, this.getSavedParams());
            } else if (this.getConfig().isRedirectEnabled()) {
                redirectedFromConfig = true;
                Redirector.redirect(this.getConfig().getRedirectAfterLogin(), this.getSavedParams());
            }
        }
        catch (PageNotFoundException cause) {
            if (redirectedFromConfig) {
                throw new ConfigurationException(this.bundle.getString("after-login-page-not-found", new Object[]{cause.getViewId()}), (Throwable)((Object)cause));
            }
            throw cause;
        }
        finally {
            this.clear();
        }
    }

    public void onLogoutSuccessful(@Observes AfterLogoutSuccessful event) {
        try {
            if (this.getConfig().isRedirectEnabled()) {
                Redirector.redirect(this.getConfig().getRedirectAfterLogout());
            }
        }
        catch (PageNotFoundException cause) {
            throw new ConfigurationException(this.bundle.getString("after-logout-page-not-found", new Object[]{cause.getViewId()}), (Throwable)((Object)cause));
        }
        finally {
            try {
                HttpSession session = (HttpSession)FacesContext.getCurrentInstance().getExternalContext().getSession(false);
                session.invalidate();
            }
            catch (IllegalStateException e) {
                this.logger.debug("Esta sess\u00e3o j\u00e1 foi invalidada.");
            }
        }
    }

    private void clear() {
        this.savedViewId = null;
        this.getSavedParams().clear();
    }
}

