/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.configuration.ExceptionHandlerConfig;
import br.gov.frameworkdemoiselle.internal.configuration.ExceptionHandlerConfigCompatible;
import br.gov.frameworkdemoiselle.internal.implementation.AbstractExceptionHandler;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Exceptions;
import br.gov.frameworkdemoiselle.util.Faces;
import br.gov.frameworkdemoiselle.util.PageNotFoundException;
import br.gov.frameworkdemoiselle.util.Redirector;
import java.util.HashMap;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.slf4j.Logger;

public class ApplicationExceptionHandler
extends AbstractExceptionHandler {
    public ApplicationExceptionHandler(ExceptionHandler wrapped) {
        super(wrapped);
    }

    @Override
    protected boolean handleException(Throwable cause, FacesContext facesContext) {
        ExceptionHandlerConfigCompatible compatibleConfig = (ExceptionHandlerConfigCompatible)Beans.getReference(ExceptionHandlerConfigCompatible.class);
        if (!compatibleConfig.getExceptionPage().equals("/application_error") || !compatibleConfig.isHandleApplicationException()) {
            Logger logger = (Logger)Beans.getReference(Logger.class);
            logger.warn("As propriedades frameworkdemoiselle.handle.application.exception e frameworkdemoiselle.handle.application.exception.page n\u00e3o ser\u00e3o suportadas nas pr\u00f3ximas vers\u00f5es do framework. Para evitar futuros problemas atualize as propriedades para frameworkdemoiselle.exception.application.handle e frameworkdemoiselle.exception.default.redirect.page, respectivamente.");
            return this.handleExceptionCompatibleConfiguration(compatibleConfig, cause, facesContext);
        }
        boolean handled = false;
        ExceptionHandlerConfig config = (ExceptionHandlerConfig)Beans.getReference(ExceptionHandlerConfig.class);
        if (config.isApplicationExceptionHandle() && Exceptions.isApplicationException((Throwable)cause)) {
            if (this.isRendering(facesContext)) {
                handled = this.handlingDuringRenderResponse(cause, config);
            } else {
                Faces.addMessage(cause);
                handled = true;
            }
        }
        return handled;
    }

    @Deprecated
    private boolean handleExceptionCompatibleConfiguration(ExceptionHandlerConfigCompatible config, Throwable cause, FacesContext facesContext) {
        boolean handled = false;
        if (config.isHandleApplicationException() && Exceptions.isApplicationException((Throwable)cause)) {
            if (this.isRendering(facesContext)) {
                handled = this.handlingDuringRenderResponseCompatible(cause, config);
            } else {
                Faces.addMessage(cause);
                handled = true;
            }
        }
        return handled;
    }

    @Deprecated
    private boolean handlingDuringRenderResponseCompatible(Throwable cause, ExceptionHandlerConfigCompatible config) {
        boolean handled = false;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("exception", cause.getMessage());
            Redirector.redirect(config.getExceptionPage(), map);
            handled = true;
        }
        catch (PageNotFoundException ex) {
            throw new DemoiselleException("A tela de exibi\u00e7\u00e3o de erros: \"" + ex.getViewId() + "\" n\u00e3o foi encontrada. Caso o seu projeto possua outra, defina no arquivo de configura\u00e7\u00e3o a chave \"" + "frameworkdemoiselle.handle.application.exception.page" + "\"", (Throwable)((Object)ex));
        }
        return handled;
    }

    private boolean isRendering(FacesContext context) {
        return PhaseId.RENDER_RESPONSE.equals(context.getCurrentPhaseId());
    }

    private boolean handlingDuringRenderResponse(Throwable cause, ExceptionHandlerConfig config) {
        boolean handled = false;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("exception", cause.getMessage());
            Redirector.redirect(config.getDefaultRedirectExceptionPage(), map);
            handled = true;
        }
        catch (PageNotFoundException ex) {
            throw new DemoiselleException("A tela de exibi\u00e7\u00e3o de erros: \"" + ex.getViewId() + "\" n\u00e3o foi encontrada. Caso o seu projeto possua outra, defina no arquivo de configura\u00e7\u00e3o a chave \"" + "frameworkdemoiselle.handle.application.exception.page" + "\"", (Throwable)((Object)ex));
        }
        return handled;
    }

    @Override
    protected Throwable getRoot(Throwable throwable) {
        Throwable root;
        for (root = throwable; root != null && !Exceptions.isApplicationException((Throwable)root); root = root.getCause()) {
        }
        return root;
    }
}

