/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.util.Beans;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Locale;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;

@Named
@SessionScoped
public class Locales
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Locale PT_BR = new Locale("pt", "BR");
    private Locale locale = Locale.getDefault();
    @Inject
    private FacesContext facesContext;

    public void setEnglish() {
        this.setCurrentLocale(Locale.US);
    }

    public void setPortuguese() {
        this.setCurrentLocale(PT_BR);
    }

    public Locale getCurrentLocale() {
        return this.locale != null ? this.locale : Locale.getDefault();
    }

    public void setCurrentLocale(Locale locale) {
        Iterator supportedLocales = this.getContext().getApplication().getSupportedLocales();
        if (supportedLocales == null) {
            this.locale = locale;
            this.getContext().getViewRoot().setLocale(this.locale);
        } else {
            boolean selectedLocale = false;
            while (supportedLocales.hasNext()) {
                Locale supportedLocale = (Locale)supportedLocales.next();
                if (!supportedLocale.equals(locale)) continue;
                this.locale = locale;
                this.getContext().getViewRoot().setLocale(this.locale);
                selectedLocale = true;
                break;
            }
            if (!selectedLocale && this.locale == null) {
                this.locale = Locale.getDefault();
            }
        }
    }

    public void setCurrentLocale(String language) {
        Locale locale = new Locale(language);
        this.setCurrentLocale(locale);
    }

    public void setApplicationLocale(Locale locale) {
        this.setCurrentLocale(locale);
        this.getContext().getApplication().setDefaultLocale(this.locale);
    }

    private FacesContext getContext() {
        if (this.facesContext == null) {
            this.facesContext = (FacesContext)Beans.getReference(FacesContext.class);
        }
        return this.facesContext;
    }
}

