/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.configuration.ExceptionHandlerConfig;
import br.gov.frameworkdemoiselle.internal.implementation.AbstractExceptionHandler;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Exceptions;
import br.gov.frameworkdemoiselle.util.Faces;
import br.gov.frameworkdemoiselle.util.PageNotFoundException;
import br.gov.frameworkdemoiselle.util.Redirector;
import java.util.HashMap;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

public class ApplicationExceptionHandler
extends AbstractExceptionHandler {
    public ApplicationExceptionHandler(ExceptionHandler wrapped) {
        super(wrapped);
    }

    @Override
    protected boolean handleException(Throwable cause, FacesContext facesContext) {
        ExceptionHandlerConfig config = (ExceptionHandlerConfig)Beans.getReference(ExceptionHandlerConfig.class);
        boolean handled = false;
        if (config.isHandleApplicationException() && Exceptions.isApplicationException((Throwable)cause)) {
            if (this.isRendering(facesContext)) {
                handled = this.handlingDuringRenderResponse(cause, config);
            } else {
                Faces.addMessage(cause);
                handled = true;
            }
        }
        return handled;
    }

    private final boolean isRendering(FacesContext context) {
        return PhaseId.RENDER_RESPONSE.equals(context.getCurrentPhaseId());
    }

    private final boolean handlingDuringRenderResponse(Throwable cause, ExceptionHandlerConfig config) {
        boolean handled = false;
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("exception", cause.getMessage());
            Redirector.redirect(config.getExceptionPage(), map);
            handled = true;
        }
        catch (PageNotFoundException ex) {
            throw new DemoiselleException("A tela de exibi\u00e7\u00e3o de erros: \"" + ex.getViewId() + "\" n\u00e3o foi encontrada. Caso o seu projeto possua outra, defina no arquivo de configura\u00e7\u00e3o a chave \"" + "frameworkdemoiselle.handle.application.exception.page" + "\"", (Throwable)((Object)ex));
        }
        return handled;
    }

    @Override
    protected Throwable getRoot(Throwable throwable) {
        Throwable root;
        for (root = throwable; root != null && !Exceptions.isApplicationException((Throwable)root); root = root.getCause()) {
        }
        return root;
    }
}

