/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.annotation.ViewScoped;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Faces;
import br.gov.frameworkdemoiselle.util.Parameter;
import br.gov.frameworkdemoiselle.util.Reflections;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.Map;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.faces.convert.Converter;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;

public class ParameterImpl<T extends Serializable>
implements Parameter<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private Class<Object> type;
    private transient Converter converter;
    private T value;
    private final String key;
    private boolean viewScoped = false;
    private boolean requestScoped = false;
    private boolean sessionScoped = false;

    @Override
    public Converter getConverter() {
        if (this.converter == null) {
            this.converter = Faces.getConverter(this.type);
        }
        return this.converter;
    }

    private HttpServletRequest getRequest() {
        return (HttpServletRequest)Beans.getReference(HttpServletRequest.class);
    }

    @Inject
    public ParameterImpl(InjectionPoint ip) {
        this.key = ip.getAnnotated().isAnnotationPresent(Name.class) ? ((Name)ip.getAnnotated().getAnnotation(Name.class)).value() : ip.getMember().getName();
        this.type = Reflections.getGenericTypeArgument((Member)ip.getMember(), (int)0);
        this.viewScoped = ip.getAnnotated().isAnnotationPresent(ViewScoped.class);
        this.requestScoped = ip.getAnnotated().isAnnotationPresent(RequestScoped.class);
        this.sessionScoped = ip.getAnnotated().isAnnotationPresent(SessionScoped.class);
    }

    @Override
    public String getKey() {
        return this.key;
    }

    private boolean isSessionScoped() {
        return this.sessionScoped;
    }

    private boolean isViewScoped() {
        return this.viewScoped;
    }

    private boolean isRequestScoped() {
        return this.requestScoped;
    }

    @Override
    public T getValue() {
        Serializable result = null;
        String parameterValue = this.getRequest().getParameter(this.key);
        if (this.isSessionScoped()) {
            if (parameterValue != null) {
                this.getRequest().getSession().setAttribute(this.key, Faces.convert(parameterValue, this.getConverter()));
            }
            result = (Serializable)this.getRequest().getSession().getAttribute(this.key);
        } else if (this.isRequestScoped()) {
            result = (Serializable)Faces.convert(parameterValue, this.getConverter());
        } else if (this.isViewScoped()) {
            Map<String, Object> viewMap = Faces.getViewMap();
            if (parameterValue != null) {
                viewMap.put(this.key, Faces.convert(parameterValue, this.getConverter()));
            }
            result = (Serializable)viewMap.get(this.key);
        } else {
            if (this.value == null) {
                this.value = (Serializable)Faces.convert(parameterValue, this.getConverter());
            }
            result = this.value;
        }
        return (T)result;
    }

    @Override
    public void setValue(T value) {
        if (this.isSessionScoped()) {
            this.getRequest().getSession().setAttribute(this.key, value);
        } else if (!this.isRequestScoped()) {
            if (this.isViewScoped()) {
                Map<String, Object> viewMap = Faces.getViewMap();
                viewMap.put(this.key, value);
            } else {
                this.value = value;
            }
        }
    }
}

