/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.message.MessageContext;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Faces;
import javax.faces.event.PhaseEvent;
import javax.faces.event.PhaseId;
import javax.faces.event.PhaseListener;
import org.slf4j.Logger;

public class MessagePhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1L;
    private final Logger logger = LoggerProducer.create(this.getClass());

    public void beforePhase(PhaseEvent e) {
        this.transferMessages(e);
    }

    public void afterPhase(PhaseEvent e) {
    }

    private void transferMessages(PhaseEvent e) {
        this.logger.debug(this.getClass().getSimpleName() + " " + e.getPhaseId());
        MessageContext messageContext = (MessageContext)Beans.getReference(MessageContext.class);
        this.logger.debug("Moving " + messageContext.getMessages().size() + " message(s) from MessageContext to FacesContext.");
        Faces.addMessages(messageContext.getMessages());
        messageContext.clear();
    }

    public PhaseId getPhaseId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

