/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.configuration.ConfigurationException;
import br.gov.frameworkdemoiselle.internal.configuration.JsfSecurityConfig;
import br.gov.frameworkdemoiselle.security.AfterLoginSuccessful;
import br.gov.frameworkdemoiselle.security.AfterLogoutSuccessful;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.PageNotFoundException;
import br.gov.frameworkdemoiselle.util.Redirector;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;

@SessionScoped
public class SecurityObserver
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private JsfSecurityConfig config;
    private transient Map<String, Object> savedParams;
    private String savedViewId;
    @Inject
    private Logger logger;

    public SecurityObserver() {
        this.clear();
    }

    private Map<String, Object> getSavedParams() {
        if (this.savedParams == null) {
            this.savedParams = new HashMap<String, Object>();
        }
        return this.savedParams;
    }

    private void saveCurrentState() {
        this.clear();
        FacesContext facesContext = (FacesContext)Beans.getReference(FacesContext.class);
        if (!this.config.getLoginPage().equals(facesContext.getViewRoot().getViewId())) {
            this.getSavedParams().putAll(facesContext.getExternalContext().getRequestParameterMap());
            this.savedViewId = facesContext.getViewRoot().getViewId();
        }
    }

    public void redirectToLoginPage() {
        this.saveCurrentState();
        try {
            Redirector.redirect(this.config.getLoginPage());
        }
        catch (PageNotFoundException cause) {
            throw new ConfigurationException("A tela de login \"" + cause.getViewId() + "\" n\u00e3o foi encontrada. Caso o seu projeto possua outra, defina no arquivo de configura\u00e7\u00e3o a chave \"" + "frameworkdemoiselle.security.login.page" + "\"", (Throwable)((Object)cause));
        }
    }

    public void onLoginSuccessful(@Observes AfterLoginSuccessful event) {
        boolean redirectedFromConfig = false;
        try {
            if (this.savedViewId != null) {
                Redirector.redirect(this.savedViewId, this.getSavedParams());
            } else if (this.config.isRedirectEnabled()) {
                redirectedFromConfig = true;
                Redirector.redirect(this.config.getRedirectAfterLogin(), this.getSavedParams());
            }
        }
        catch (PageNotFoundException cause) {
            if (redirectedFromConfig) {
                throw new ConfigurationException("A tela \"" + cause.getViewId() + "\" que \u00e9 invocada ap\u00f3s o logon n\u00e3o foi encontrada. Caso o seu projeto possua outra, defina no arquivo de configura\u00e7\u00e3o a chave \"" + "frameworkdemoiselle.security.redirect.after.login" + "\"", (Throwable)((Object)cause));
            }
            throw cause;
        }
        finally {
            this.clear();
        }
    }

    public void onLogoutSuccessful(@Observes AfterLogoutSuccessful event) {
        try {
            if (this.config.isRedirectEnabled()) {
                Redirector.redirect(this.config.getRedirectAfterLogout());
            }
        }
        catch (PageNotFoundException cause) {
            throw new ConfigurationException("A tela \"" + cause.getViewId() + "\" que \u00e9 invocada ap\u00f3s o logout n\u00e3o foi encontrada. Caso o seu projeto possua outra, defina no arquivo de configura\u00e7\u00e3o a chave \"" + "frameworkdemoiselle.security.redirect.after.logout" + "\"", (Throwable)((Object)cause));
        }
        finally {
            try {
                ((HttpSession)Beans.getReference(HttpSession.class)).invalidate();
            }
            catch (IllegalStateException e) {
                this.logger.debug("Esta sess\u00e3o j\u00e1 foi invalidada.");
            }
        }
    }

    private void clear() {
        this.savedViewId = null;
        this.getSavedParams().clear();
    }
}

