/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.internal.configuration.EntityManagerConfig;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerFactoryProducer;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerStore;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;

public abstract class AbstractEntityManagerStore
implements EntityManagerStore {
    private static final long serialVersionUID = 1L;
    private final Map<String, EntityManager> cache = Collections.synchronizedMap(new HashMap());

    @Override
    public EntityManager getEntityManager(String persistenceUnit) {
        EntityManager entityManager = null;
        if (this.cache.containsKey(persistenceUnit)) {
            entityManager = this.cache.get(persistenceUnit);
        } else {
            entityManager = this.getFactory().create(persistenceUnit).createEntityManager();
            entityManager.setFlushMode(FlushModeType.AUTO);
            this.cache.put(persistenceUnit, entityManager);
            this.getLogger().info(this.getBundle().getString("entity-manager-was-created", new Object[]{persistenceUnit}));
        }
        return entityManager;
    }

    void init() {
        for (String persistenceUnit : this.getFactory().getCache().keySet()) {
            this.getEntityManager(persistenceUnit);
        }
    }

    void close() {
        EntityManagerConfig configuration = this.getConfiguration();
        if (configuration.getEntityManagerScope() != EntityManagerConfig.EntityManagerScope.NOSCOPE) {
            for (EntityManager entityManager : this.cache.values()) {
                entityManager.close();
            }
        }
        this.cache.clear();
    }

    @Override
    public Map<String, EntityManager> getCache() {
        if (this.cache == null || this.cache.isEmpty()) {
            this.init();
        }
        return this.cache;
    }

    private EntityManagerFactoryProducer getFactory() {
        return (EntityManagerFactoryProducer)Beans.getReference(EntityManagerFactoryProducer.class);
    }

    private Logger getLogger() {
        return (Logger)Beans.getReference(Logger.class, (Annotation[])new Annotation[]{new NameQualifier("br.gov.frameworkdemoiselle.util")});
    }

    private ResourceBundle getBundle() {
        return (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-jpa-bundle")});
    }

    private EntityManagerConfig getConfiguration() {
        return (EntityManagerConfig)Beans.getReference(EntityManagerConfig.class);
    }
}

