/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.transaction;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerProducer;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.util.Beans;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;

@Priority(value=2147483547)
public class JPATransaction
implements Transaction {
    private static final long serialVersionUID = 1L;
    private EntityManagerProducer producer;

    private EntityManagerProducer getProducer() {
        if (this.producer == null) {
            this.producer = (EntityManagerProducer)Beans.getReference(EntityManagerProducer.class);
        }
        return this.producer;
    }

    public Collection<EntityManager> getDelegate() {
        return this.getProducer().getCache().values();
    }

    public void begin() {
        for (EntityManager entityManager : this.getDelegate()) {
            EntityTransaction transaction = entityManager.getTransaction();
            if (transaction.isActive()) continue;
            transaction.begin();
        }
    }

    public void commit() {
        for (EntityManager entityManager : this.getDelegate()) {
            EntityTransaction transaction = entityManager.getTransaction();
            if (!transaction.isActive()) continue;
            transaction.commit();
        }
    }

    public void rollback() {
        for (EntityManager entityManager : this.getDelegate()) {
            EntityTransaction transaction = entityManager.getTransaction();
            if (!transaction.isActive()) continue;
            transaction.rollback();
        }
    }

    public void setRollbackOnly() {
        for (EntityManager entityManager : this.getDelegate()) {
            EntityTransaction transaction = entityManager.getTransaction();
            if (!transaction.isActive()) continue;
            transaction.setRollbackOnly();
        }
    }

    public boolean isActive() {
        boolean active = false;
        for (EntityManager entityManager : this.getDelegate()) {
            EntityTransaction transaction = entityManager.getTransaction();
            if (!transaction.isActive()) continue;
            active = true;
            break;
        }
        return active;
    }

    public boolean isMarkedRollback() {
        boolean rollbackOnly = false;
        for (EntityManager entityManager : this.getDelegate()) {
            EntityTransaction transaction = entityManager.getTransaction();
            if (!transaction.isActive() || !transaction.getRollbackOnly()) continue;
            rollbackOnly = true;
            break;
        }
        return rollbackOnly;
    }
}

