/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.template;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.pagination.Pagination;
import br.gov.frameworkdemoiselle.pagination.PaginationContext;
import br.gov.frameworkdemoiselle.template.Crud;
import br.gov.frameworkdemoiselle.transaction.Transactional;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.Reflections;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.Enumerated;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;

public class JPACrud<T, I>
implements Crud<T, I> {
    private static final long serialVersionUID = 1L;
    private EntityManager entityManager;
    private Pagination pagination;
    @Inject
    @Name(value="demoiselle-jpa-bundle")
    private Instance<ResourceBundle> bundle;
    private Class<T> beanClass;

    protected Class<T> getBeanClass() {
        if (this.beanClass == null) {
            this.beanClass = Reflections.getGenericTypeArgument(this.getClass(), (int)0);
        }
        return this.beanClass;
    }

    protected CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManager().getCriteriaBuilder();
    }

    protected EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = (EntityManager)Beans.getReference(EntityManager.class);
        }
        return this.entityManager;
    }

    protected Pagination getPagination() {
        if (this.pagination == null) {
            try {
                PaginationContext context = (PaginationContext)Beans.getReference(PaginationContext.class);
                this.pagination = context.getPagination(this.getBeanClass());
            }
            catch (ContextNotActiveException cause) {
                this.pagination = null;
            }
        }
        return this.pagination;
    }

    protected CriteriaQuery<T> createCriteriaQuery() {
        return this.getCriteriaBuilder().createQuery(this.getBeanClass());
    }

    protected Query createQuery(String ql) {
        return this.getEntityManager().createQuery(ql);
    }

    protected void handleException(Throwable cause) throws Throwable {
        if (cause instanceof TransactionRequiredException) {
            String message = ((ResourceBundle)this.bundle.get()).getString("no-transaction-active", new Object[]{"frameworkdemoiselle.transaction.class", "demoiselle"});
            throw new DemoiselleException(message, cause);
        }
        throw cause;
    }

    @Transactional
    public T insert(T entity) {
        this.getEntityManager().persist(entity);
        return entity;
    }

    @Transactional
    public void delete(I id) {
        Object entity = this.getEntityManager().getReference(this.getBeanClass(), id);
        this.getEntityManager().remove(entity);
    }

    @Transactional
    public T update(T entity) {
        return (T)this.getEntityManager().merge(entity);
    }

    public T load(I id) {
        return (T)this.getEntityManager().find(this.getBeanClass(), id);
    }

    public List<T> findAll() {
        return this.findByJPQL("select this from " + this.getBeanClass().getSimpleName() + " this");
    }

    protected List<T> findByJPQL(String jpql) {
        TypedQuery listQuery = this.getEntityManager().createQuery(jpql, this.getBeanClass());
        if (this.getPagination() != null) {
            String countQuery = this.createCountQuery(jpql);
            Query query = this.getEntityManager().createQuery(countQuery);
            Number cResults = (Number)query.getSingleResult();
            this.getPagination().setTotalResults(cResults.intValue());
            listQuery.setFirstResult(this.getPagination().getFirstResult());
            listQuery.setMaxResults(this.getPagination().getPageSize());
        }
        return listQuery.getResultList();
    }

    protected List<T> findByCriteriaQuery(CriteriaQuery<T> criteriaQuery) {
        TypedQuery listQuery = this.getEntityManager().createQuery(criteriaQuery);
        if (this.getPagination() != null) {
            CriteriaBuilder builder = this.getEntityManager().getCriteriaBuilder();
            CriteriaQuery countQuery = builder.createQuery(Long.class);
            countQuery.select((Selection)builder.count((Expression)countQuery.from(this.getBeanClass())));
            countQuery.where((Expression)criteriaQuery.getRestriction());
            this.getEntityManager().createQuery(countQuery);
            this.getPagination().setTotalResults((int)((Long)this.getEntityManager().createQuery(countQuery).getSingleResult() + 0L));
            listQuery.setFirstResult(this.getPagination().getFirstResult());
            listQuery.setMaxResults(this.getPagination().getPageSize());
        }
        return listQuery.getResultList();
    }

    private String createCountQuery(String query) {
        String result = query;
        Matcher matcher = Pattern.compile("[Ss][Ee][Ll][Ee][Cc][Tt](.+)[Ff][Rr][Oo][Mm]").matcher(result);
        if (matcher.find()) {
            String group = matcher.group(1).trim();
            result = result.replaceFirst(group, "COUNT(" + group + ")");
            matcher = Pattern.compile("[Oo][Rr][Dd][Ee][Rr](.+)").matcher(result);
            if (matcher.find()) {
                group = matcher.group(0);
                result = result.replaceFirst(group, "");
            }
        } else {
            throw new DemoiselleException(((ResourceBundle)this.bundle.get()).getString("malformed-jpql"));
        }
        return result;
    }

    protected List<T> findByExample(T example) {
        CriteriaQuery<T> criteria = this.createCriteriaByExample(example);
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    private CriteriaQuery<T> createCriteriaByExample(T example) {
        Field[] fields;
        CriteriaBuilder builder = this.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(this.getBeanClass());
        Root entity = query.from(this.getBeanClass());
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        for (Field field : fields = example.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(Column.class) && !field.isAnnotationPresent(Basic.class) && !field.isAnnotationPresent(Enumerated.class)) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(example);
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (IllegalAccessException e) {
                continue;
            }
            if (value == null) continue;
            Predicate pred = builder.equal((Expression)entity.get(field.getName()), value);
            predicates.add(pred);
        }
        return query.where(predicates.toArray(new Predicate[0])).select((Selection)entity);
    }
}

