/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.EntityManagerConfig;
import br.gov.frameworkdemoiselle.internal.producer.ApplicationEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.ConversationEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.DependentEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerFactoryProducer;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.RequestEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.SessionEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.producer.ViewEntityManagerStore;
import br.gov.frameworkdemoiselle.internal.proxy.EntityManagerProxy;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import org.slf4j.Logger;

@ApplicationScoped
public class EntityManagerProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private Logger logger;
    @Inject
    @Name(value="demoiselle-jpa-bundle")
    private ResourceBundle bundle;
    @Inject
    private EntityManagerFactoryProducer factory;
    @Inject
    private Instance<EntityManagerStore> storeInstance;
    @Inject
    private EntityManagerConfig configuration;

    @Default
    @Produces
    protected EntityManager createDefault(InjectionPoint ip, EntityManagerConfig config) {
        String persistenceUnit = this.getFromProperties(config);
        if (persistenceUnit == null) {
            persistenceUnit = this.getFromXML();
        }
        return new EntityManagerProxy(persistenceUnit);
    }

    @Name(value="")
    @Produces
    protected EntityManager createNamed(InjectionPoint ip, EntityManagerConfig config) {
        String persistenceUnit = ((Name)ip.getAnnotated().getAnnotation(Name.class)).value();
        return new EntityManagerProxy(persistenceUnit);
    }

    private String getFromProperties(EntityManagerConfig config) {
        String persistenceUnit = config.getDefaultPersistenceUnitName();
        if (persistenceUnit != null) {
            this.logger.debug(this.bundle.getString("getting-persistence-unit-from-properties", new Object[]{"demoiselle"}));
        }
        return persistenceUnit;
    }

    private String getFromXML() {
        Set<String> persistenceUnits = this.factory.getCache().keySet();
        if (persistenceUnits.size() > 1) {
            throw new DemoiselleException(this.bundle.getString("more-than-one-persistence-unit-defined", new Object[]{Name.class.getSimpleName()}));
        }
        return persistenceUnits.iterator().next();
    }

    public EntityManager getEntityManager(String persistenceUnit) {
        return this.getStore().getEntityManager(persistenceUnit);
    }

    public Map<String, EntityManager> getCache() {
        return this.getStore().getCache();
    }

    private EntityManagerStore getStore() {
        switch (this.configuration.getEntityManagerScope()) {
            case REQUEST: {
                return (EntityManagerStore)this.storeInstance.select(RequestEntityManagerStore.class, new Annotation[0]).get();
            }
            case APPLICATION: {
                return (EntityManagerStore)this.storeInstance.select(ApplicationEntityManagerStore.class, new Annotation[0]).get();
            }
            case CONVERSATION: {
                return (EntityManagerStore)this.storeInstance.select(ConversationEntityManagerStore.class, new Annotation[0]).get();
            }
            case NOSCOPE: {
                return (EntityManagerStore)this.storeInstance.select(DependentEntityManagerStore.class, new Annotation[0]).get();
            }
            case SESSION: {
                return (EntityManagerStore)this.storeInstance.select(SessionEntityManagerStore.class, new Annotation[0]).get();
            }
            case VIEW: {
                return (EntityManagerStore)this.storeInstance.select(ViewEntityManagerStore.class, new Annotation[0]).get();
            }
        }
        return (EntityManagerStore)this.storeInstance.select(RequestEntityManagerStore.class, new Annotation[0]).get();
    }
}

