/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.proxy;

import br.gov.frameworkdemoiselle.internal.producer.EntityManagerProducer;
import br.gov.frameworkdemoiselle.internal.proxy.QueryProxy;
import br.gov.frameworkdemoiselle.internal.proxy.TypedQueryProxy;
import br.gov.frameworkdemoiselle.util.Beans;
import java.io.Serializable;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TransactionRequiredException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.Metamodel;

public class EntityManagerProxy
implements EntityManager,
Serializable {
    private static final long serialVersionUID = 1L;
    private String persistenceUnit;

    public EntityManagerProxy(String persistenceUnit) {
        this.persistenceUnit = persistenceUnit;
    }

    private EntityManager getEntityManagerDelegate() {
        EntityManagerProducer emp = (EntityManagerProducer)Beans.getReference(EntityManagerProducer.class);
        return emp.getEntityManager(this.persistenceUnit);
    }

    public void persist(Object entity) {
        this.joinTransactionIfNecessary();
        this.getEntityManagerDelegate().persist(entity);
    }

    public <T> T merge(T entity) {
        this.joinTransactionIfNecessary();
        return (T)this.getEntityManagerDelegate().merge(entity);
    }

    public void remove(Object entity) {
        this.joinTransactionIfNecessary();
        this.getEntityManagerDelegate().remove(entity);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        this.joinTransactionIfNecessary();
        return (T)this.getEntityManagerDelegate().find(entityClass, primaryKey);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        this.joinTransactionIfNecessary();
        return (T)this.getEntityManagerDelegate().find(entityClass, primaryKey, properties);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        this.joinTransactionIfNecessary();
        return (T)this.getEntityManagerDelegate().find(entityClass, primaryKey, lockMode);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        this.joinTransactionIfNecessary();
        return (T)this.getEntityManagerDelegate().find(entityClass, primaryKey, lockMode, properties);
    }

    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        this.joinTransactionIfNecessary();
        return (T)this.getEntityManagerDelegate().getReference(entityClass, primaryKey);
    }

    public void flush() {
        this.getEntityManagerDelegate().flush();
    }

    public void setFlushMode(FlushModeType flushMode) {
        this.getEntityManagerDelegate().setFlushMode(flushMode);
    }

    public FlushModeType getFlushMode() {
        return this.getEntityManagerDelegate().getFlushMode();
    }

    public void lock(Object entity, LockModeType lockMode) {
        this.joinTransactionIfNecessary();
        this.getEntityManagerDelegate().lock(entity, lockMode);
    }

    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.joinTransactionIfNecessary();
        this.getEntityManagerDelegate().lock(entity, lockMode, properties);
    }

    public void refresh(Object entity) {
        this.joinTransactionIfNecessary();
        this.getEntityManagerDelegate().refresh(entity);
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.joinTransactionIfNecessary();
        this.getEntityManagerDelegate().refresh(entity, properties);
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.joinTransactionIfNecessary();
        this.getEntityManagerDelegate().refresh(entity, lockMode);
    }

    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.joinTransactionIfNecessary();
        this.getEntityManagerDelegate().refresh(entity, lockMode, properties);
    }

    public void clear() {
        this.getEntityManagerDelegate().clear();
    }

    public void detach(Object entity) {
        this.getEntityManagerDelegate().detach(entity);
    }

    public boolean contains(Object entity) {
        return this.getEntityManagerDelegate().contains(entity);
    }

    public LockModeType getLockMode(Object entity) {
        this.joinTransactionIfNecessary();
        return this.getEntityManagerDelegate().getLockMode(entity);
    }

    public void setProperty(String propertyName, Object value) {
        this.getEntityManagerDelegate().setProperty(propertyName, value);
    }

    public Map<String, Object> getProperties() {
        return this.getEntityManagerDelegate().getProperties();
    }

    public Query createQuery(String qlString) {
        return new QueryProxy(this.getEntityManagerDelegate().createQuery(qlString), this);
    }

    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        return new TypedQueryProxy(this.getEntityManagerDelegate().createQuery(criteriaQuery), this);
    }

    public <T> TypedQuery<T> createQuery(String qlString, Class<T> resultClass) {
        return new TypedQueryProxy(this.getEntityManagerDelegate().createQuery(qlString, resultClass), this);
    }

    public Query createNamedQuery(String name) {
        return new QueryProxy(this.getEntityManagerDelegate().createNamedQuery(name), this);
    }

    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        return this.getEntityManagerDelegate().createNamedQuery(name, resultClass);
    }

    public Query createNativeQuery(String sqlString) {
        return new QueryProxy(this.getEntityManagerDelegate().createNativeQuery(sqlString), this);
    }

    public Query createNativeQuery(String sqlString, Class resultClass) {
        return new QueryProxy(this.getEntityManagerDelegate().createNativeQuery(sqlString, resultClass), this);
    }

    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        return new QueryProxy(this.getEntityManagerDelegate().createNativeQuery(sqlString, resultSetMapping), this);
    }

    public void joinTransaction() {
        this.getEntityManagerDelegate().joinTransaction();
    }

    protected final void joinTransactionIfNecessary() {
        try {
            this.getEntityManagerDelegate().getTransaction();
        }
        catch (IllegalStateException cause) {
            try {
                this.getEntityManagerDelegate().joinTransaction();
            }
            catch (TransactionRequiredException transactionRequiredException) {
                // empty catch block
            }
        }
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getEntityManagerDelegate().unwrap(cls);
    }

    public Object getDelegate() {
        return this.getEntityManagerDelegate().getDelegate();
    }

    public void close() {
        this.getEntityManagerDelegate().close();
    }

    public boolean isOpen() {
        return this.getEntityManagerDelegate().isOpen();
    }

    public EntityTransaction getTransaction() {
        return this.getEntityManagerDelegate().getTransaction();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.getEntityManagerDelegate().getEntityManagerFactory();
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getEntityManagerDelegate().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getEntityManagerDelegate().getMetamodel();
    }

    public boolean equals(Object arg0) {
        return this.getEntityManagerDelegate().equals(arg0);
    }

    public int hashCode() {
        return this.getEntityManagerDelegate().hashCode();
    }

    public String toString() {
        return this.getEntityManagerDelegate().toString();
    }
}

