/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.EntityManagerConfig;
import br.gov.frameworkdemoiselle.internal.producer.EntityManagerFactoryProducer;
import br.gov.frameworkdemoiselle.internal.proxy.EntityManagerProxy;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import org.slf4j.Logger;

@RequestScoped
public class EntityManagerProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private Logger logger;
    @Inject
    @Name(value="demoiselle-jpa-bundle")
    private ResourceBundle bundle;
    private final Map<String, EntityManager> cache = Collections.synchronizedMap(new HashMap());
    @Inject
    private EntityManagerFactoryProducer factory;

    @Default
    @Produces
    public EntityManager create(InjectionPoint ip, EntityManagerConfig config) {
        String persistenceUnit = this.getPersistenceUnit(ip, config);
        return new EntityManagerProxy(persistenceUnit);
    }

    public EntityManager getEntityManager(String persistenceUnit) {
        EntityManager entityManager = null;
        if (this.cache.containsKey(persistenceUnit)) {
            entityManager = this.cache.get(persistenceUnit);
        } else {
            entityManager = this.factory.create(persistenceUnit).createEntityManager();
            entityManager.setFlushMode(FlushModeType.AUTO);
            this.cache.put(persistenceUnit, entityManager);
            this.logger.info(this.bundle.getString("entity-manager-was-created", new Object[]{persistenceUnit}));
        }
        return entityManager;
    }

    private String getPersistenceUnit(InjectionPoint ip, EntityManagerConfig config) {
        String persistenceUnitName;
        if (ip != null && ip.getAnnotated() != null && ip.getAnnotated().isAnnotationPresent(Name.class)) {
            persistenceUnitName = ((Name)ip.getAnnotated().getAnnotation(Name.class)).value();
        } else {
            persistenceUnitName = this.getFromProperties(config);
            if (persistenceUnitName == null) {
                persistenceUnitName = this.getFromXML();
            }
        }
        return persistenceUnitName;
    }

    private String getFromProperties(EntityManagerConfig config) {
        String persistenceUnit = config.getPersistenceUnitName();
        if (persistenceUnit != null) {
            this.logger.debug(this.bundle.getString("getting-persistence-unit-from-properties", new Object[]{"demoiselle"}));
        }
        return persistenceUnit;
    }

    private String getFromXML() {
        Set<String> persistenceUnits = this.factory.getCache().keySet();
        if (persistenceUnits.size() > 1) {
            throw new DemoiselleException(this.bundle.getString("more-than-one-persistence-unit-defined", new Object[]{Name.class.getSimpleName()}));
        }
        return persistenceUnits.iterator().next();
    }

    @PostConstruct
    public void init() {
        for (String persistenceUnit : this.factory.getCache().keySet()) {
            this.getEntityManager(persistenceUnit);
        }
    }

    @PreDestroy
    public void close() {
        for (EntityManager entityManager : this.cache.values()) {
            entityManager.close();
        }
        this.cache.clear();
    }

    public Map<String, EntityManager> getCache() {
        return this.cache;
    }
}

