/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.implementation;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.producer.LoggerProducer;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.lang.management.ManagementFactory;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class MBeanHelper {
    private static final Logger logger = LoggerProducer.create((String)"br.gov.frameworkdemoiselle.management");
    private static ResourceBundle bundle = new ResourceBundle("demoiselle-jmx-bundle", Locale.getDefault());
    private static final MBeanServer server = ManagementFactory.getPlatformMBeanServer();

    public static final MBeanServer getMBeanServer() {
        return server;
    }

    public static ObjectInstance register(Object mbean, String name) {
        logger.fine(bundle.getString("mbean-registration", new Object[]{name}));
        ObjectInstance instance = null;
        try {
            ObjectName objectName = new ObjectName(name);
            instance = server.registerMBean(mbean, objectName);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, bundle.getString("mbean-registration-error", new Object[]{name}), e);
            throw new DemoiselleException(bundle.getString("mbean-registration-error", new Object[]{name}), (Throwable)e);
        }
        return instance;
    }

    public static void unregister(ObjectName objectName) {
        logger.fine(bundle.getString("mbean-deregistration", new Object[]{objectName.getCanonicalName()}));
        try {
            server.unregisterMBean(objectName);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, bundle.getString("mbean-deregistration", new Object[]{objectName.getCanonicalName()}), e);
            throw new DemoiselleException(bundle.getString("mbean-deregistration", new Object[]{objectName.getCanonicalName()}), (Throwable)e);
        }
    }
}

