/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.jmx.internal;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.management.ManagedType;
import br.gov.frameworkdemoiselle.internal.management.Management;
import br.gov.frameworkdemoiselle.internal.producer.ResourceBundleProducer;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ReflectionException;

public class DynamicMBeanProxy
implements DynamicMBean {
    private MBeanInfo delegateInfo;
    private ManagedType managedType;
    private ResourceBundle bundle = ResourceBundleProducer.create((String)"demoiselle-jmx-bundle", (Locale)Locale.getDefault());

    public DynamicMBeanProxy(ManagedType type) {
        if (type == null) {
            throw new NullPointerException(this.bundle.getString("mbean-null-type-defined"));
        }
        this.managedType = type;
    }

    @Override
    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        if (this.delegateInfo == null) {
            this.initializeMBeanInfo();
        }
        Management manager = (Management)Beans.getReference(Management.class);
        return manager.getProperty(this.managedType, attribute);
    }

    @Override
    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.delegateInfo == null) {
            this.initializeMBeanInfo();
        }
        Management manager = (Management)Beans.getReference(Management.class);
        manager.setProperty(this.managedType, attribute.getName(), attribute.getValue());
    }

    @Override
    public AttributeList getAttributes(String[] attributes) {
        if (attributes != null) {
            AttributeList list = new AttributeList();
            for (String attribute : attributes) {
                try {
                    Object value = this.getAttribute(attribute);
                    list.add(new Attribute(attribute, value));
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return list;
        }
        return null;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList settedAttributes = new AttributeList();
        if (attributes != null) {
            for (Attribute attribute : attributes.asList()) {
                try {
                    this.setAttribute(attribute);
                    Attribute attributeWithNewValue = new Attribute(attribute.getName(), this.getAttribute(attribute.getName()));
                    settedAttributes.add(attributeWithNewValue);
                }
                catch (Throwable t) {}
            }
        }
        return settedAttributes;
    }

    @Override
    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        if (this.delegateInfo == null) {
            this.initializeMBeanInfo();
        }
        Management manager = (Management)Beans.getReference(Management.class);
        return manager.invoke(this.managedType, actionName, params);
    }

    private void initializeMBeanInfo() {
        ArrayList<MBeanAttributeInfo> attributes = new ArrayList<MBeanAttributeInfo>();
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        for (Map.Entry fieldEntry : this.managedType.getFields().entrySet()) {
            try {
                MBeanAttributeInfo attributeInfo = new MBeanAttributeInfo((String)fieldEntry.getKey(), ((ManagedType.FieldDetail)fieldEntry.getValue()).getDescription(), ((ManagedType.FieldDetail)fieldEntry.getValue()).getGetterMethod(), ((ManagedType.FieldDetail)fieldEntry.getValue()).getSetterMethod());
                attributes.add(attributeInfo);
            }
            catch (IntrospectionException e) {
                throw new DemoiselleException(this.bundle.getString("mbean-introspection-error", new Object[]{this.managedType.getType().getSimpleName()}));
            }
        }
        for (Map.Entry methodEntry : this.managedType.getOperationMethods().entrySet()) {
            MBeanParameterInfo[] parameters;
            ManagedType.MethodDetail methodDetail = (ManagedType.MethodDetail)methodEntry.getValue();
            ManagedType.ParameterDetail[] parameterTypes = methodDetail.getParameterTypers();
            MBeanParameterInfo[] mBeanParameterInfoArray = parameters = parameterTypes.length > 0 ? new MBeanParameterInfo[parameterTypes.length] : null;
            if (parameters != null) {
                for (int i = 0; i < parameterTypes.length; ++i) {
                    parameters[i] = new MBeanParameterInfo(parameterTypes[i].getParameterName(), parameterTypes[i].getParameterType().getCanonicalName(), parameterTypes[i].getParameterDescription());
                }
            }
            int operationType = 0;
            switch (methodDetail.getType()) {
                case ACTION: {
                    operationType = 1;
                    break;
                }
                case INFO: {
                    operationType = 0;
                    break;
                }
                case ACTION_INFO: {
                    operationType = 2;
                    break;
                }
                default: {
                    operationType = 3;
                }
            }
            MBeanOperationInfo operation = new MBeanOperationInfo(methodDetail.getMethod().getName(), methodDetail.getDescription(), parameters, methodDetail.getMethod().getReturnType().getName(), operationType);
            operations.add(operation);
        }
        this.delegateInfo = new MBeanInfo(this.managedType.getType().getCanonicalName(), this.managedType.getDescription(), attributes.toArray(new MBeanAttributeInfo[0]), null, operations.toArray(new MBeanOperationInfo[0]), null);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.delegateInfo == null) {
            this.initializeMBeanInfo();
        }
        return this.delegateInfo;
    }
}

