/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.configuration;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.configuration.ConfigurationValueExtractor;
import br.gov.frameworkdemoiselle.internal.configuration.JDBCConfigurationStore;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;

@Priority(value=2147483547)
public class JDBCConfigValueExtractor
implements ConfigurationValueExtractor {
    public Object getValue(String prefix, String key, Field field, Configuration configuration) throws Exception {
        JDBCConfigurationStore value = null;
        String regexp = "^(" + prefix + ")((.+)\\.)?(" + key + ")$";
        Pattern pattern = Pattern.compile(regexp);
        Iterator iter = configuration.getKeys();
        while (iter.hasNext()) {
            String iterKey = (String)iter.next();
            Matcher matcher = pattern.matcher(iterKey);
            if (!matcher.matches()) continue;
            String confKey = matcher.group(1) + (matcher.group(2) == null ? "" : matcher.group(2)) + matcher.group(4);
            if (value == null) {
                value = new JDBCConfigurationStore();
            }
            String mapKey = matcher.group(3) == null ? "default" : matcher.group(3);
            value.put(mapKey, configuration.getString(confKey));
        }
        return value;
    }

    public boolean isSupported(Field field) {
        return field.getType() == JDBCConfigurationStore.class;
    }
}

