/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.JDBCConfig;
import br.gov.frameworkdemoiselle.internal.producer.DataSourceProducer;
import br.gov.frameworkdemoiselle.internal.proxy.ConnectionProxy;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;

@RequestScoped
public class ConnectionProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Logger logger;
    private transient ResourceBundle bundle;
    private final Map<String, Connection> cache = Collections.synchronizedMap(new HashMap());
    private final Map<Connection, Status> statusCache = Collections.synchronizedMap(new HashMap());
    @Inject
    private DataSourceProducer producer;

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-jdbc-bundle")});
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = (Logger)Beans.getReference(Logger.class, (Annotation[])new Annotation[]{new NameQualifier("br.gov.frameworkdemoiselle.util")});
        }
        return this.logger;
    }

    @PostConstruct
    public void init() {
        for (String name : this.producer.getCache().keySet()) {
            this.getConnection(name);
        }
    }

    @Default
    @Produces
    public Connection createDefault(InjectionPoint ip, JDBCConfig config) {
        String name = this.getNameFromProperties(config);
        if (name == null) {
            name = this.getNameFromCache();
        }
        return new ConnectionProxy(name);
    }

    @Name(value="")
    @Produces
    public Connection createNamed(InjectionPoint ip, JDBCConfig config) {
        String name = ((Name)ip.getAnnotated().getAnnotation(Name.class)).value();
        return new ConnectionProxy(name);
    }

    public Connection getConnection(String name) {
        Connection connection = null;
        if (this.cache.containsKey(name)) {
            connection = this.cache.get(name);
        } else {
            try {
                connection = this.producer.create(name).getConnection();
                this.setTransactionIsolationLevel(connection);
                this.disableAutoCommit(connection);
                this.cache.put(name, connection);
                this.statusCache.put(connection, new Status());
                this.getLogger().info(this.getBundle().getString("connection-was-created", new Object[]{name}));
            }
            catch (Exception cause) {
                throw new DemoiselleException(this.getBundle().getString("connection-creation-failed", new Object[]{name}), (Throwable)cause);
            }
        }
        return connection;
    }

    private void setTransactionIsolationLevel(Connection connection) {
        try {
            connection.setTransactionIsolation(2);
        }
        catch (SQLException cause) {
            this.getLogger().warning(this.getBundle().getString("set-autocommit-failed"));
        }
    }

    private void disableAutoCommit(Connection connection) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException cause) {
            this.getLogger().warning(this.getBundle().getString("set-autocommit-failed"));
        }
    }

    private String getNameFromProperties(JDBCConfig config) {
        String result = config.getDefaultDataSourceName();
        if (result != null) {
            this.getLogger().fine(this.getBundle().getString("getting-default-datasource-name-from-properties", new Object[]{result}));
        }
        return result;
    }

    private String getNameFromCache() {
        Set<String> names = this.producer.getCache().keySet();
        if (names.size() > 1) {
            throw new DemoiselleException(this.getBundle().getString("more-than-one-datasource-defined", new Object[]{Name.class.getSimpleName()}));
        }
        String result = names.iterator().next();
        return result;
    }

    @PreDestroy
    public void close() {
        for (String key : this.cache.keySet()) {
            Connection connection = this.cache.get(key);
            try {
                if (connection.isClosed()) {
                    this.getLogger().warning(this.getBundle().getString("connection-has-already-been-closed", new Object[]{key}));
                    continue;
                }
                connection.close();
                this.getLogger().info(this.getBundle().getString("connection-was-closed", new Object[]{key}));
            }
            catch (Exception cause) {
                throw new DemoiselleException(this.getBundle().getString("connection-close-failed", new Object[]{key}), (Throwable)cause);
            }
        }
        this.cache.clear();
    }

    public Map<String, Connection> getCache() {
        return this.cache;
    }

    public Status getStatus(Connection connection) {
        return this.statusCache.get(connection);
    }

    public static class Status
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean active = false;
        private boolean markedRollback = false;

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isMarkedRollback() {
            return this.markedRollback;
        }

        public void setRollbackOnly(boolean markedRollback) {
            this.markedRollback = markedRollback;
        }
    }
}

