/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.transaction;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.internal.producer.ConnectionProducer;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.transaction.TransactionException;
import br.gov.frameworkdemoiselle.util.Beans;
import java.sql.Connection;
import java.util.Collection;

@Priority(value=2147483547)
public class JDBCTransaction
implements Transaction {
    private static final long serialVersionUID = 1L;
    private ConnectionProducer producer;

    private ConnectionProducer getProducer() {
        if (this.producer == null) {
            this.producer = (ConnectionProducer)Beans.getReference(ConnectionProducer.class);
        }
        return this.producer;
    }

    private Collection<Connection> getDelegate() {
        return this.getProducer().getCache().values();
    }

    public void begin() {
        for (Connection connection : this.getDelegate()) {
            ConnectionProducer.Status status = this.getProducer().getStatus(connection);
            status.setActive(true);
        }
    }

    public void commit() {
        for (Connection connection : this.getDelegate()) {
            try {
                connection.commit();
                ConnectionProducer.Status status = this.getProducer().getStatus(connection);
                status.setActive(false);
            }
            catch (Exception cause) {
                throw new TransactionException((Throwable)cause);
            }
        }
    }

    public void rollback() {
        for (Connection connection : this.getDelegate()) {
            try {
                connection.rollback();
                ConnectionProducer.Status status = this.getProducer().getStatus(connection);
                status.setActive(false);
            }
            catch (Exception cause) {
                throw new TransactionException((Throwable)cause);
            }
        }
    }

    public void setRollbackOnly() {
        for (Connection connection : this.getDelegate()) {
            ConnectionProducer.Status status = this.getProducer().getStatus(connection);
            status.setRollbackOnly(true);
        }
    }

    public boolean isActive() {
        boolean result = true;
        for (Connection connection : this.getDelegate()) {
            ConnectionProducer.Status status = this.getProducer().getStatus(connection);
            result = result && status.isActive();
        }
        return result;
    }

    public boolean isMarkedRollback() {
        boolean result = true;
        for (Connection connection : this.getDelegate()) {
            ConnectionProducer.Status status = this.getProducer().getStatus(connection);
            result = result && status.isMarkedRollback();
        }
        return result;
    }
}

