/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.configuration.JDBCConfig;
import br.gov.frameworkdemoiselle.internal.proxy.BasicDataSourceProxy;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

@ApplicationScoped
public class DataSourceProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Logger logger;
    private transient ResourceBundle bundle;
    private final Map<ClassLoader, Map<String, DataSource>> cache = Collections.synchronizedMap(new HashMap());

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = (ResourceBundle)Beans.getReference(ResourceBundle.class, (Annotation[])new Annotation[]{new NameQualifier("demoiselle-jdbc-bundle")});
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = (Logger)Beans.getReference(Logger.class, (Annotation[])new Annotation[]{new NameQualifier("br.gov.frameworkdemoiselle.util")});
        }
        return this.logger;
    }

    @PostConstruct
    public void loadDataSources() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (String dataBaseName : this.getDataSourceNames(contextClassLoader)) {
            try {
                this.create(dataBaseName);
            }
            catch (Exception cause) {
                throw new DemoiselleException((Throwable)cause);
            }
            this.getLogger().fine(this.getBundle().getString("datasource-name-found", new Object[]{dataBaseName}));
        }
    }

    private Set<String> getDataSourceNames(ClassLoader classLoader) {
        HashSet<String> result = new HashSet<String>();
        JDBCConfig config = (JDBCConfig)Beans.getReference(JDBCConfig.class);
        if (config.getJndiName() != null) {
            result.addAll(config.getJndiName().keySet());
        }
        if (config.getDriverClass() != null) {
            result.addAll(config.getDriverClass().keySet());
        }
        if (result.isEmpty()) {
            throw new DemoiselleException(this.getBundle().getString("datasource-name-not-found"));
        }
        return result;
    }

    DataSource create(String dataSourceName) {
        DataSource factory;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.cache.containsKey(contextClassLoader)) {
            Map<String, DataSource> localCache = this.cache.get(contextClassLoader);
            if (localCache.containsKey(dataSourceName)) {
                factory = localCache.get(dataSourceName);
            } else {
                factory = this.initDataSource(dataSourceName);
                localCache.put(dataSourceName, factory);
                this.cache.put(contextClassLoader, localCache);
            }
        } else {
            HashMap<String, DataSource> localCache = new HashMap<String, DataSource>();
            factory = this.initDataSource(dataSourceName);
            localCache.put(dataSourceName, factory);
            this.cache.put(contextClassLoader, localCache);
        }
        return factory;
    }

    private DataSource initDataSource(String dataSourceName) {
        Object result;
        String url;
        JDBCConfig config = (JDBCConfig)Beans.getReference(JDBCConfig.class);
        String jndi = config.getJndiName() == null ? null : config.getJndiName().get(dataSourceName);
        String string = url = config.getUrl() == null ? null : config.getUrl().get(dataSourceName);
        if (jndi != null) {
            result = this.initJNDIDataSource(dataSourceName, jndi);
        } else if (url != null) {
            result = new BasicDataSourceProxy(dataSourceName, config, this.getBundle());
        } else {
            throw new DemoiselleException(this.getBundle().getString("uncompleted-datasource-configuration", new Object[]{dataSourceName}));
        }
        return result;
    }

    private DataSource initJNDIDataSource(String dataSourceName, String jndi) {
        DataSource result = null;
        try {
            InitialContext context = new InitialContext();
            result = (DataSource)context.lookup(jndi);
        }
        catch (NamingException cause) {
            throw new DemoiselleException(this.getBundle().getString("load-jndi-datasource-failed", new Object[]{dataSourceName, jndi}), (Throwable)cause);
        }
        catch (ClassCastException cause) {
            throw new DemoiselleException(this.getBundle().getString("load-duplicated-configuration-failed"), (Throwable)cause);
        }
        return result;
    }

    @PreDestroy
    public void close() {
        this.cache.clear();
    }

    Map<String, DataSource> getCache() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Map<String, DataSource> result = this.cache.get(classLoader);
        if (result == null || result.isEmpty()) {
            this.getLogger().fine(this.getBundle().getString("datasource-not-found-in-cache"));
            for (String name : this.getDataSourceNames(classLoader)) {
                this.create(name);
                result = this.cache.get(classLoader);
            }
        }
        return result;
    }
}

