/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.transaction;

import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.internal.producer.ConnectionProducer;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.transaction.TransactionException;
import br.gov.frameworkdemoiselle.util.Beans;
import java.io.Serializable;
import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@Priority(value=2147483547)
public class JDBCTransaction
implements Transaction {
    private static final long serialVersionUID = 1L;
    private ConnectionProducer producer;
    private Map<Connection, Status> cache = Collections.synchronizedMap(new HashMap());

    private ConnectionProducer getProducer() {
        if (this.producer == null) {
            this.producer = (ConnectionProducer)Beans.getReference(ConnectionProducer.class);
            for (Connection connection : this.producer.getCache().values()) {
                if (this.cache.containsKey(connection)) continue;
                this.cache.put(connection, new Status());
            }
        }
        return this.producer;
    }

    public Collection<Connection> getDelegate() {
        return this.getProducer().getCache().values();
    }

    public void begin() {
        for (Connection connection : this.getDelegate()) {
            Status status = this.cache.get(connection);
            status.setActive(true);
        }
    }

    public void commit() {
        for (Connection connection : this.getDelegate()) {
            try {
                connection.commit();
            }
            catch (Exception cause) {
                throw new TransactionException((Throwable)cause);
            }
        }
    }

    public void rollback() {
        for (Connection connection : this.getDelegate()) {
            try {
                connection.rollback();
            }
            catch (Exception cause) {
                throw new TransactionException((Throwable)cause);
            }
        }
    }

    public void setRollbackOnly() {
        for (Connection connection : this.getDelegate()) {
            Status status = this.cache.get(connection);
            status.setRollbackOnly(true);
        }
    }

    public boolean isActive() {
        boolean result = true;
        for (Connection connection : this.getDelegate()) {
            Status status = this.cache.get(connection);
            result = result && status.isActive();
        }
        return result;
    }

    public boolean isMarkedRollback() {
        boolean result = true;
        for (Connection connection : this.getDelegate()) {
            Status status = this.cache.get(connection);
            result = result && status.isMarkedRollback();
        }
        return result;
    }

    private static class Status
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private boolean active = false;
        private boolean markedRollback = false;

        private Status() {
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isMarkedRollback() {
            return this.markedRollback;
        }

        public void setRollbackOnly(boolean markedRollback) {
            this.markedRollback = markedRollback;
        }
    }
}

