/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.JDBCConfig;
import br.gov.frameworkdemoiselle.internal.producer.DataSourceProducer;
import br.gov.frameworkdemoiselle.internal.proxy.ConnectionProxy;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.slf4j.Logger;

@RequestScoped
public class ConnectionProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private Logger logger;
    @Inject
    @Name(value="demoiselle-jdbc-bundle")
    private ResourceBundle bundle;
    private final Map<String, Connection> cache = Collections.synchronizedMap(new HashMap());
    @Inject
    private DataSourceProducer producer;

    @PostConstruct
    public void init() {
        for (String name : this.producer.getCache().keySet()) {
            this.getConnection(name);
        }
    }

    @Default
    @Produces
    public Connection createDefault(InjectionPoint ip, JDBCConfig config) {
        String name = this.getNameFromProperties(config);
        if (name == null) {
            name = this.getNameFromCache();
        }
        return new ConnectionProxy(name);
    }

    @Name(value="")
    @Produces
    public Connection createNamed(InjectionPoint ip, JDBCConfig config) {
        String name = ((Name)ip.getAnnotated().getAnnotation(Name.class)).value();
        return new ConnectionProxy(name);
    }

    public Connection getConnection(String name) {
        Connection connection = null;
        if (this.cache.containsKey(name)) {
            connection = this.cache.get(name);
        } else {
            try {
                connection = this.producer.create(name).getConnection();
                this.disableAutoCommit(connection);
                this.cache.put(name, connection);
                this.logger.info(this.bundle.getString("connection-was-created", new Object[]{name}));
            }
            catch (Exception cause) {
                throw new DemoiselleException(this.bundle.getString("connection-creation-failed", new Object[]{name}), (Throwable)cause);
            }
        }
        return connection;
    }

    private void disableAutoCommit(Connection connection) {
        try {
            connection.setAutoCommit(false);
        }
        catch (SQLException cause) {
            this.logger.debug(this.bundle.getString("set-autocommit-failed"));
        }
    }

    private String getNameFromProperties(JDBCConfig config) {
        String result = config.getDefaultDataDourceName();
        if (result != null) {
            this.logger.debug(this.bundle.getString("getting-default-datasource-name-from-properties", new Object[]{result}));
        }
        return result;
    }

    private String getNameFromCache() {
        Set<String> names = this.producer.getCache().keySet();
        if (names.size() > 1) {
            throw new DemoiselleException(this.bundle.getString("more-than-one-datasource-defined", new Object[]{Name.class.getSimpleName()}));
        }
        String result = names.iterator().next();
        return result;
    }

    @PreDestroy
    public void close() {
        for (String key : this.cache.keySet()) {
            Connection connection = this.cache.get(key);
            try {
                if (connection.isClosed()) {
                    this.logger.warn(this.bundle.getString("connection-has-already-been-closed", new Object[]{key}));
                    continue;
                }
                connection.close();
                this.logger.info(this.bundle.getString("connection-was-closed", new Object[]{key}));
            }
            catch (Exception cause) {
                throw new DemoiselleException(this.bundle.getString("connection-close-failed", new Object[]{key}), (Throwable)cause);
            }
        }
        this.cache.clear();
    }

    public Map<String, Connection> getCache() {
        return this.cache;
    }
}

