/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.transaction;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.internal.configuration.JDBCConfig;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.dbcp.BasicDataSource;

public class BasicDataSourceProxy
extends BasicDataSource
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ResourceBundle bundle;
    private String dataSourceName;
    private JDBCConfig config;
    private transient BasicDataSource delegate;

    public BasicDataSourceProxy(String dataSourceName, JDBCConfig config, ResourceBundle bundle) {
        this.dataSourceName = dataSourceName;
        this.config = config;
        this.bundle = bundle;
    }

    private BasicDataSource getDelegate() {
        if (this.delegate == null) {
            BasicDataSource dataSource = new BasicDataSource();
            try {
                String driver = this.config.getDriverClass().get(this.dataSourceName);
                String url = this.config.getUrl().get(this.dataSourceName);
                String username = this.config.getUsername().get(this.dataSourceName);
                String password = this.config.getPassword().get(this.dataSourceName);
                dataSource.setDriverClassName(driver);
                dataSource.setUrl(url);
                dataSource.setUsername(username);
                dataSource.setPassword(password);
            }
            catch (ClassCastException cause) {
                throw new DemoiselleException(this.bundle.getString("load-duplicated-configuration-failed"), (Throwable)cause);
            }
            this.delegate = dataSource;
        }
        return this.delegate;
    }

    public boolean getDefaultAutoCommit() {
        return this.getDelegate().getDefaultAutoCommit();
    }

    public void setDefaultAutoCommit(boolean defaultAutoCommit) {
        this.getDelegate().setDefaultAutoCommit(defaultAutoCommit);
    }

    public boolean getDefaultReadOnly() {
        return this.getDelegate().getDefaultReadOnly();
    }

    public void setDefaultReadOnly(boolean defaultReadOnly) {
        this.getDelegate().setDefaultReadOnly(defaultReadOnly);
    }

    public int getDefaultTransactionIsolation() {
        return this.getDelegate().getDefaultTransactionIsolation();
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.getDelegate().setDefaultTransactionIsolation(defaultTransactionIsolation);
    }

    public String getDefaultCatalog() {
        return this.getDelegate().getDefaultCatalog();
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.getDelegate().setDefaultCatalog(defaultCatalog);
    }

    public String getDriverClassName() {
        return this.getDelegate().getDriverClassName();
    }

    public void setDriverClassName(String driverClassName) {
        this.getDelegate().setDriverClassName(driverClassName);
    }

    public ClassLoader getDriverClassLoader() {
        return this.getDelegate().getDriverClassLoader();
    }

    public void setDriverClassLoader(ClassLoader driverClassLoader) {
        this.getDelegate().setDriverClassLoader(driverClassLoader);
    }

    public int getMaxActive() {
        return this.getDelegate().getMaxActive();
    }

    public void setMaxActive(int maxActive) {
        this.getDelegate().setMaxActive(maxActive);
    }

    public int getMaxIdle() {
        return this.getDelegate().getMaxIdle();
    }

    public void setMaxIdle(int maxIdle) {
        this.getDelegate().setMaxIdle(maxIdle);
    }

    public int getMinIdle() {
        return this.getDelegate().getMinIdle();
    }

    public void setMinIdle(int minIdle) {
        this.getDelegate().setMinIdle(minIdle);
    }

    public int getInitialSize() {
        return this.getDelegate().getInitialSize();
    }

    public void setInitialSize(int initialSize) {
        this.getDelegate().setInitialSize(initialSize);
    }

    public long getMaxWait() {
        return this.getDelegate().getMaxWait();
    }

    public void setMaxWait(long maxWait) {
        this.getDelegate().setMaxWait(maxWait);
    }

    public boolean isPoolPreparedStatements() {
        return this.getDelegate().isPoolPreparedStatements();
    }

    public void setPoolPreparedStatements(boolean poolingStatements) {
        this.getDelegate().setPoolPreparedStatements(poolingStatements);
    }

    public int getMaxOpenPreparedStatements() {
        return this.getDelegate().getMaxOpenPreparedStatements();
    }

    public void setMaxOpenPreparedStatements(int maxOpenStatements) {
        this.getDelegate().setMaxOpenPreparedStatements(maxOpenStatements);
    }

    public boolean getTestOnBorrow() {
        return this.getDelegate().getTestOnBorrow();
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.getDelegate().setTestOnBorrow(testOnBorrow);
    }

    public boolean getTestOnReturn() {
        return this.getDelegate().getTestOnReturn();
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.getDelegate().setTestOnReturn(testOnReturn);
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.getDelegate().getTimeBetweenEvictionRunsMillis();
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.getDelegate().setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public int getNumTestsPerEvictionRun() {
        return this.getDelegate().getNumTestsPerEvictionRun();
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.getDelegate().setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.getDelegate().getMinEvictableIdleTimeMillis();
    }

    public void setMinEvictableIdleTimeMillis(long minEvictableIdleTimeMillis) {
        this.getDelegate().setMinEvictableIdleTimeMillis(minEvictableIdleTimeMillis);
    }

    public boolean getTestWhileIdle() {
        return this.getDelegate().getTestWhileIdle();
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.getDelegate().setTestWhileIdle(testWhileIdle);
    }

    public int getNumActive() {
        return this.getDelegate().getNumActive();
    }

    public int getNumIdle() {
        return this.getDelegate().getNumIdle();
    }

    public String getPassword() {
        return this.getDelegate().getPassword();
    }

    public void setPassword(String password) {
        this.getDelegate().setPassword(password);
    }

    public String getUrl() {
        return this.getDelegate().getUrl();
    }

    public void setUrl(String url) {
        this.getDelegate().setUrl(url);
    }

    public String getUsername() {
        return this.getDelegate().getUsername();
    }

    public void setUsername(String username) {
        this.getDelegate().setUsername(username);
    }

    public String getValidationQuery() {
        return this.getDelegate().getValidationQuery();
    }

    public void setValidationQuery(String validationQuery) {
        this.getDelegate().setValidationQuery(validationQuery);
    }

    public int getValidationQueryTimeout() {
        return this.getDelegate().getValidationQueryTimeout();
    }

    public void setValidationQueryTimeout(int timeout) {
        this.getDelegate().setValidationQueryTimeout(timeout);
    }

    public Collection getConnectionInitSqls() {
        return this.getDelegate().getConnectionInitSqls();
    }

    public void setConnectionInitSqls(Collection connectionInitSqls) {
        this.getDelegate().setConnectionInitSqls(connectionInitSqls);
    }

    public void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.getDelegate().setAccessToUnderlyingConnectionAllowed(allow);
    }

    public Connection getConnection(String user, String pass) throws SQLException {
        return this.getDelegate().getConnection(user, pass);
    }

    public int getLoginTimeout() throws SQLException {
        return this.getDelegate().getLoginTimeout();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getDelegate().getLogWriter();
    }

    public void setLoginTimeout(int loginTimeout) throws SQLException {
        this.getDelegate().setLoginTimeout(loginTimeout);
    }

    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.getDelegate().setLogWriter(logWriter);
    }

    public boolean getRemoveAbandoned() {
        return this.getDelegate().getRemoveAbandoned();
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.getDelegate().setRemoveAbandoned(removeAbandoned);
    }

    public int getRemoveAbandonedTimeout() {
        return this.getDelegate().getRemoveAbandonedTimeout();
    }

    public void setRemoveAbandonedTimeout(int removeAbandonedTimeout) {
        this.getDelegate().setRemoveAbandonedTimeout(removeAbandonedTimeout);
    }

    public boolean getLogAbandoned() {
        return this.getDelegate().getLogAbandoned();
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.getDelegate().setLogAbandoned(logAbandoned);
    }

    public void addConnectionProperty(String name, String value) {
        this.getDelegate().addConnectionProperty(name, value);
    }

    public void removeConnectionProperty(String name) {
        this.getDelegate().removeConnectionProperty(name);
    }

    public void setConnectionProperties(String connectionProperties) {
        this.getDelegate().setConnectionProperties(connectionProperties);
    }

    public void close() throws SQLException {
        this.getDelegate().close();
    }

    public boolean equals(Object arg0) {
        return this.getDelegate().equals(arg0);
    }

    public Connection getConnection() throws SQLException {
        return this.getDelegate().getConnection();
    }

    public int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.getDelegate().isAccessToUnderlyingConnectionAllowed();
    }

    public boolean isClosed() {
        return this.getDelegate().isClosed();
    }

    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.getDelegate().isWrapperFor(iface);
    }

    public String toString() {
        return this.getDelegate().toString();
    }

    public <T> T unwrap(Class<T> iface) throws SQLException {
        return (T)this.getDelegate().unwrap(iface);
    }
}

