/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Name;
import br.gov.frameworkdemoiselle.internal.configuration.JDBCConfig;
import br.gov.frameworkdemoiselle.transaction.BasicDataSourceProxy;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.slf4j.Logger;

@ApplicationScoped
public class DataSourceProducer
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Inject
    private Logger logger;
    @Inject
    @Name(value="demoiselle-jdbc-bundle")
    private ResourceBundle bundle;
    private final Map<ClassLoader, Map<String, DataSource>> cache = Collections.synchronizedMap(new HashMap());

    @PostConstruct
    public void loadDataSources() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        for (String dataBaseName : this.getDataSourceNames(contextClassLoader)) {
            try {
                this.create(dataBaseName);
            }
            catch (Throwable t) {
                throw new DemoiselleException(t);
            }
            this.logger.debug(this.bundle.getString("datasource-name-found", new Object[]{dataBaseName}));
        }
    }

    private Set<String> getDataSourceNames(ClassLoader classLoader) {
        HashSet<String> result = new HashSet<String>();
        JDBCConfig config = (JDBCConfig)Beans.getReference(JDBCConfig.class);
        if (config.getJndiName() != null) {
            result.addAll(config.getJndiName().keySet());
        }
        if (config.getDriverClass() != null) {
            result.addAll(config.getDriverClass().keySet());
        }
        if (result.isEmpty()) {
            throw new DemoiselleException(this.bundle.getString("datasource-name-not-found"));
        }
        return result;
    }

    public DataSource create(String dataSourceName) {
        DataSource factory;
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        if (this.cache.containsKey(contextClassLoader)) {
            Map<String, DataSource> localCache = this.cache.get(contextClassLoader);
            if (localCache.containsKey(dataSourceName)) {
                factory = localCache.get(dataSourceName);
            } else {
                factory = this.initDataSource(dataSourceName);
                localCache.put(dataSourceName, factory);
                this.cache.put(contextClassLoader, localCache);
            }
        } else {
            HashMap<String, DataSource> localCache = new HashMap<String, DataSource>();
            factory = this.initDataSource(dataSourceName);
            localCache.put(dataSourceName, factory);
            this.cache.put(contextClassLoader, localCache);
        }
        return factory;
    }

    private DataSource initDataSource(String dataSourceName) {
        Object result;
        String url;
        JDBCConfig config = (JDBCConfig)Beans.getReference(JDBCConfig.class);
        String jndi = config.getJndiName() == null ? null : config.getJndiName().get(dataSourceName);
        String string = url = config.getUrl() == null ? null : config.getUrl().get(dataSourceName);
        if (jndi != null) {
            result = this.initJNDIDataSource(dataSourceName, jndi);
        } else if (url != null) {
            result = new BasicDataSourceProxy(dataSourceName, config, this.bundle);
        } else {
            throw new DemoiselleException(this.bundle.getString("uncompleted-datasource-configuration", new Object[]{dataSourceName}));
        }
        return result;
    }

    private DataSource initJNDIDataSource(String dataSourceName, String jndi) {
        DataSource result = null;
        try {
            InitialContext context = new InitialContext();
            result = (DataSource)context.lookup(jndi);
        }
        catch (NamingException cause) {
            throw new DemoiselleException(this.bundle.getString("load-jndi-datasource-failed", new Object[]{dataSourceName}), (Throwable)cause);
        }
        catch (ClassCastException cause) {
            throw new DemoiselleException(this.bundle.getString("load-duplicated-configuration-failed"), (Throwable)cause);
        }
        return result;
    }

    @PreDestroy
    public void close() {
        this.cache.clear();
    }

    public Map<String, DataSource> getCache() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Map<String, DataSource> result = this.cache.get(classLoader);
        if (result == null || result.isEmpty()) {
            this.logger.debug(this.bundle.getString("datasource-not-found-in-cache"));
            for (String name : this.getDataSourceNames(classLoader)) {
                this.create(name);
                result = this.cache.get(classLoader);
            }
        }
        return result;
    }
}

