/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.transaction;

import br.gov.frameworkdemoiselle.exception.ApplicationException;
import br.gov.frameworkdemoiselle.transaction.AfterTransactionBegin;
import br.gov.frameworkdemoiselle.transaction.BeforeTransactionComplete;
import br.gov.frameworkdemoiselle.transaction.Transaction;
import br.gov.frameworkdemoiselle.transaction.TransactionContext;
import br.gov.frameworkdemoiselle.transaction.Transactional;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.inject.Any;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;

@Interceptor
@Transactional
public class TransactionalInterceptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private TransactionContext transactionContext;
    private TransactionInfo transactionInfo;
    private transient ResourceBundle bundle;
    private transient Logger logger;

    private TransactionContext getTransactionContext() {
        if (this.transactionContext == null) {
            this.transactionContext = Beans.getReference(TransactionContext.class);
        }
        return this.transactionContext;
    }

    private TransactionInfo newTransactionInfo() {
        TransactionInfo instance;
        try {
            instance = Beans.getReference(TransactionInfo.class);
            instance.getCounter();
        }
        catch (ContextNotActiveException cause) {
            instance = new VoidTransactionInfo();
        }
        return instance;
    }

    private TransactionInfo getTransactionInfo() {
        if (this.transactionInfo == null) {
            this.transactionInfo = this.newTransactionInfo();
        }
        return this.transactionInfo;
    }

    @AroundInvoke
    public Object manage(InvocationContext ic) throws Exception {
        Object result = null;
        try {
            this.initiate();
            this.getLogger().finer(this.getBundle().getString("transactional-execution", ic.getMethod().toGenericString()));
            result = ic.proceed();
        }
        catch (Exception cause) {
            this.handleException(cause);
            throw cause;
        }
        finally {
            this.complete();
        }
        return result;
    }

    private void initiate() {
        Transaction transaction = this.getTransactionContext().getCurrentTransaction();
        if (!transaction.isActive()) {
            transaction.begin();
            this.getTransactionInfo().markAsOwner();
            this.getLogger().fine(this.getBundle().getString("begin-transaction"));
            this.fireAfterTransactionBegin();
        }
        this.getTransactionInfo().incrementCounter();
    }

    private void handleException(Exception cause) {
        Transaction transaction = this.getTransactionContext().getCurrentTransaction();
        if (!transaction.isMarkedRollback()) {
            boolean rollback = false;
            ApplicationException annotation = cause.getClass().getAnnotation(ApplicationException.class);
            if (annotation == null || annotation.rollback()) {
                rollback = true;
            }
            if (rollback) {
                this.setRollbackOnly(transaction, cause);
            }
        }
    }

    private void setRollbackOnly(Transaction transaction, Exception cause) {
        transaction.setRollbackOnly();
        this.getLogger().fine(this.getBundle().getString("transaction-marked-rollback", cause.getMessage()));
    }

    private void complete() throws Exception {
        Transaction transaction = this.getTransactionContext().getCurrentTransaction();
        this.getTransactionInfo().decrementCounter();
        if (this.getTransactionInfo().getCounter() == 0 && transaction.isActive()) {
            if (this.getTransactionInfo().isOwner()) {
                this.complete(transaction);
            }
        } else if (this.getTransactionInfo().getCounter() == 0 && !transaction.isActive()) {
            this.getLogger().fine(this.getBundle().getString("transaction-already-finalized"));
        }
    }

    private void complete(Transaction transaction) throws Exception {
        try {
            this.fireBeforeTransactionComplete(transaction.isMarkedRollback());
        }
        catch (Exception cause) {
            this.setRollbackOnly(transaction, cause);
            throw cause;
        }
        finally {
            if (transaction.isMarkedRollback()) {
                transaction.rollback();
                this.getTransactionInfo().clear();
                this.getLogger().fine(this.getBundle().getString("transaction-rolledback"));
            } else {
                transaction.commit();
                this.getTransactionInfo().clear();
                this.getLogger().fine(this.getBundle().getString("transaction-commited"));
            }
        }
    }

    private void fireAfterTransactionBegin() {
        Beans.getBeanManager().fireEvent((Object)new AfterTransactionBegin(){
            private static final long serialVersionUID = 1L;
        }, new Annotation[0]);
    }

    private void fireBeforeTransactionComplete(final boolean markedRollback) {
        Beans.getBeanManager().fireEvent((Object)new BeforeTransactionComplete(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isMarkedRollback() {
                return markedRollback;
            }
        }, new Annotation[0]);
    }

    private ResourceBundle getBundle() {
        if (this.bundle == null) {
            this.bundle = Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
        }
        return this.bundle;
    }

    private Logger getLogger() {
        if (this.logger == null) {
            this.logger = Beans.getReference(Logger.class, new NameQualifier("br.gov.frameworkdemoiselle.transaction"));
        }
        return this.logger;
    }

    @Any
    static class VoidTransactionInfo
    extends TransactionInfo {
        private static final long serialVersionUID = 1L;

        VoidTransactionInfo() {
        }

        @Override
        public boolean isOwner() {
            return false;
        }
    }

    @RequestScoped
    public static class TransactionInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int counter = 0;
        private boolean owner;

        public TransactionInfo() {
            this.clear();
        }

        public void clear() {
            this.owner = false;
            this.counter = 0;
        }

        public int getCounter() {
            return this.counter;
        }

        public void incrementCounter() {
            ++this.counter;
        }

        public void decrementCounter() {
            --this.counter;
        }

        public void markAsOwner() {
            this.owner = true;
        }

        public boolean isOwner() {
            return this.owner;
        }
    }
}

