/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.internal.producer;

import br.gov.frameworkdemoiselle.DemoiselleException;
import br.gov.frameworkdemoiselle.annotation.Priority;
import br.gov.frameworkdemoiselle.util.Beans;
import br.gov.frameworkdemoiselle.util.NameQualifier;
import br.gov.frameworkdemoiselle.util.ResourceBundle;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.spi.Bean;

public final class StrategySelector
implements Serializable {
    private static final long serialVersionUID = 1L;

    private StrategySelector() {
    }

    public static <T> T selectReference(Class<T> type, Collection<? extends T> options) {
        HashMap map = new HashMap();
        for (T instance : options) {
            if (instance == null) continue;
            map.put(instance.getClass(), instance);
        }
        Class<? extends T> elected = StrategySelector.selectClass(type, map.keySet());
        return (T)map.get(elected);
    }

    protected static <T> T selectReference(Class<T> type) {
        Class<? extends T> selected = StrategySelector.selectClass(type, StrategySelector.getOptions(type, new Annotation[0]));
        return Beans.getReference(selected);
    }

    protected static <T> Class<? extends T> selectClass(Class<T> type) {
        return StrategySelector.selectClass(type, StrategySelector.getOptions(type, new Annotation[0]));
    }

    private static <T> Class<? extends T> selectClass(Class<T> type, Collection<Class<? extends T>> options) {
        Class<T> selected = null;
        for (Class<T> clazz : options) {
            if (selected != null && StrategySelector.getPriority(clazz) >= StrategySelector.getPriority(selected)) continue;
            selected = clazz;
        }
        if (selected != null) {
            StrategySelector.performAmbiguityCheck(type, selected, options);
        }
        return selected;
    }

    private static <T> Collection<Class<? extends T>> getOptions(Class<T> type, Annotation ... qualifiers) {
        HashSet<Class<T>> result = new HashSet<Class<T>>();
        for (Bean bean : Beans.getBeanManager().getBeans(type, qualifiers)) {
            result.add(bean.getBeanClass());
        }
        return result;
    }

    private static <T> void performAmbiguityCheck(Class<T> type, Class<? extends T> selected, Collection<Class<? extends T>> options) {
        int selectedPriority = StrategySelector.getPriority(selected);
        ArrayList<Class<T>> ambiguous = new ArrayList<Class<T>>();
        for (Class<T> clazz : options) {
            if (selected == clazz || selectedPriority != StrategySelector.getPriority(clazz)) continue;
            ambiguous.add(clazz);
        }
        if (!ambiguous.isEmpty()) {
            ambiguous.add(selected);
            String message = StrategySelector.getExceptionMessage(type, ambiguous);
            throw new DemoiselleException(message, (Throwable)new AmbiguousResolutionException());
        }
    }

    private static <T> String getExceptionMessage(Class<T> type, List<Class<? extends T>> ambiguous) {
        StringBuffer classes = new StringBuffer();
        int i = 0;
        for (Class<T> clazz : ambiguous) {
            if (i++ != 0) {
                classes.append(", ");
            }
            classes.append(clazz.getCanonicalName());
        }
        return StrategySelector.getBundle().getString("ambiguous-strategy-resolution", type.getCanonicalName(), classes.toString());
    }

    private static <T> int getPriority(Class<T> type) {
        int result = Integer.MIN_VALUE;
        Priority priority = type.getAnnotation(Priority.class);
        if (priority != null) {
            result = priority.value();
        }
        return result;
    }

    private static ResourceBundle getBundle() {
        return Beans.getReference(ResourceBundle.class, new NameQualifier("demoiselle-core-bundle"));
    }
}

