/*
 * Decompiled with CFR 0.152.
 */
package br.gov.frameworkdemoiselle.util;

import br.gov.frameworkdemoiselle.annotation.Ignore;
import br.gov.frameworkdemoiselle.util.Reflections;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Strings {
    private Strings() {
    }

    public static boolean isResourceBundleKeyFormat(String key) {
        return Pattern.matches("^\\{(.+)\\}$", key == null ? "" : key);
    }

    public static String removeChars(String string, char ... chars) {
        String result = string;
        if (result != null) {
            for (char ch : chars) {
                result = result.replace(String.valueOf(ch), "");
            }
        }
        return result;
    }

    public static String join(String separator, String ... strings) {
        StringBuffer result = new StringBuffer();
        if (strings != null) {
            for (int i = 0; i < strings.length; ++i) {
                if (i != 0 && separator != null) {
                    result.append(separator);
                }
                if (strings[i] == null) continue;
                result.append(strings[i]);
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }

    public static String insertZeros(String string, int howMuchZeros) {
        StringBuffer result = new StringBuffer((string == null ? "" : string).trim());
        int difference = howMuchZeros - result.toString().length();
        for (int j = 0; j < difference; ++j) {
            result.insert(0, '0');
        }
        return result.toString();
    }

    public static String getString(String string, Object ... params) {
        String result = null;
        if (string != null) {
            result = new String(string);
        }
        if (params != null && string != null) {
            for (int i = 0; i < params.length; ++i) {
                if (params[i] == null) continue;
                result = result.replaceAll("\\{" + i + "\\}", Matcher.quoteReplacement(params[i].toString()));
            }
        }
        return result;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    public static String toString(Object object) {
        StringBuffer result = new StringBuffer();
        if (object != null) {
            result.append(object.getClass().getSimpleName());
            result.append(" [");
            boolean first = true;
            for (Field field : Reflections.getNonStaticDeclaredFields(object.getClass())) {
                if (field.isAnnotationPresent(Ignore.class)) continue;
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                result.append(field.getName());
                result.append('=');
                Object fieldValue = Reflections.getFieldValue(field, object);
                result.append((Object)(fieldValue != null && fieldValue.getClass().isArray() ? Arrays.toString((Object[])fieldValue) : fieldValue));
            }
            result.append(']');
        }
        return result.toString();
    }

    public static String camelCaseToSymbolSeparated(String string, String symbol) {
        if (symbol == null) {
            symbol = "";
        }
        return string == null ? null : string.replaceAll("\\B([A-Z])", symbol + "$1").toLowerCase();
    }

    public static String firstToUpper(String string) {
        String result = string;
        if (!Strings.isEmpty(string)) {
            result = string.toUpperCase().charAt(0) + (string.length() > 1 ? string.substring(1) : "");
        }
        return result;
    }

    public static String removeBraces(String string) {
        String result = string;
        if (Strings.isResourceBundleKeyFormat(string)) {
            result = string.substring(1, string.length() - 1);
        }
        return result;
    }

    public static String insertBraces(String string) {
        String result = string;
        if (!Strings.isEmpty(string)) {
            result = "{" + string + "}";
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String parse(InputStream inputStream) throws IOException {
        StringBuilder result = new StringBuilder();
        if (inputStream != null) {
            try (BufferedReader reader = null;){
                String line;
                reader = new BufferedReader(new InputStreamReader(inputStream));
                while ((line = reader.readLine()) != null) {
                    result.append(line);
                }
            }
        }
        return result.length() > 0 ? result.toString() : null;
    }
}

